/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

/**
 * JdkEncoder
 */
public class JdkEncoder implements Encoder {

	private CharsetEncoder ce;

	public JdkEncoder(Charset charset) {
		this.ce = charset.newEncoder();
	}

	public float maxBytesPerChar() {
		return ce.maxBytesPerChar();
	}

	public int encode(char[] chars, int offset, int len, byte[] bytes) {
		ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = CharBuffer.wrap(chars, offset, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow())
                cr.throwException();
            cr = ce.flush(bb);
            if (!cr.isUnderflow())
                cr.throwException();
            return bb.position();
        } catch (CharacterCodingException x) {
            // Substitution is always enabled,
            // so this shouldn't happen
        	throw new RuntimeException("Encode error: " + x.getMessage(), x);
        }
	}
}






