/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

/**
 * IWritable 支持 OutputStream、Writer 双模式动态切换输出
 *
 * 详见 cn.aifei.enjoy.stat.ast.Text 中的用法
 */
public interface IWritable {

	/**
	 * 供 OutputStream 模式下的 ByteWrite 使用
	 */
	public byte[] getBytes();

	/**
	 * 供 Writer 模式下的 CharWrite 使用
	 */
	public char[] getChars();
}



