/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

import java.io.IOException;

/**
 * FloatingWriter
 */
public class FloatingWriter {

	public static void write(ByteWriter byteWriter, double doubleValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(doubleValue);
		char[] chars = byteWriter.chars;
		byte[] bytes = byteWriter.bytes;
		int len = fd.getChars(chars);
		for (int i=0; i<len; i++) {
			bytes[i] = (byte)chars[i];
		}
		byteWriter.out.write(bytes, 0, len);
	}

	public static void write(ByteWriter byteWriter, float floatValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(floatValue);
		char[] chars = byteWriter.chars;
		byte[] bytes = byteWriter.bytes;
		int len = fd.getChars(chars);
		for (int i=0; i<len; i++) {
			bytes[i] = (byte)chars[i];
		}
		byteWriter.out.write(bytes, 0, len);
	}

	public static void write(CharWriter charWriter, double doubleValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(doubleValue);
		char[] chars = charWriter.chars;
		int len = fd.getChars(chars);
		charWriter.out.write(chars, 0, len);
	}

	public static void write(CharWriter charWriter, float floatValue) throws IOException {
		FloatingDecimal fd = new FloatingDecimal(floatValue);
		char[] chars = charWriter.chars;
		int len = fd.getChars(chars);
		charWriter.out.write(chars, 0, len);
	}
}






