/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.io;

import java.nio.charset.Charset;

import cn.aifei.enjoy.EngineConfig;

/**
 * EncoderFactory
 */
public class EncoderFactory {

	protected Charset charset = Charset.forName(EngineConfig.DEFAULT_ENCODING);

	void setEncoding(String encoding) {
		charset = Charset.forName(encoding);
	}

	public Encoder getEncoder() {
		if (Charset.forName("UTF-8").equals(charset)) {
			return Utf8Encoder.me;
		} else {
			return new JdkEncoder(charset);
		}
	}
}




