/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.ext.extensionmethod;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 针对 java.lang.Short 的扩展方法
 *
 * 用法：
 * #if(value.toInt() == 123)
 */
public class ShortExt {

	public Boolean toBoolean(Short self) {
		return self != 0;
	}

	public Integer toInt(Short self) {
		return self.intValue();
	}

	public Long toLong(Short self) {
		return self.longValue();
	}

	public Float toFloat(Short self) {
		return self.floatValue();
	}

	public Double toDouble(Short self) {
		return self.doubleValue();
	}

	public Short toShort(Short self) {
		return self;
	}

	public Byte toByte(Short self) {
		return self.byteValue();
	}

	public BigInteger toBigInteger(Short self) {
		return BigInteger.valueOf(self);
	}

	public BigDecimal toBigDecimal(Short self) {
		return new BigDecimal(self);
	}
}




