/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.ext.extensionmethod;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 针对 java.lang.Long 的扩展方法
 *
 * 用法：
 * #if(value.toInt() == 123)
 */
public class LongExt {

	public Boolean toBoolean(Long self) {
		return self != 0;
	}

	public Integer toInt(Long self) {
		return self.intValue();
	}

	public Long toLong(Long self) {
		return self;
	}

	public Float toFloat(Long self) {
		return self.floatValue();
	}

	public Double toDouble(Long self) {
		return self.doubleValue();
	}

	public Short toShort(Long self) {
		return self.shortValue();
	}

	public Byte toByte(Long self) {
		return self.byteValue();
	}

	public BigInteger toBigInteger(Long self) {
		return BigInteger.valueOf(self);
	}

	public BigDecimal toBigDecimal(Long self) {
		return new BigDecimal(self);
	}
}




