/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.ext.extensionmethod;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 针对 java.lang.Double 的扩展方法
 *
 * 用法：
 * #if(value.toInt() == 123)
 */
public class DoubleExt {

	public Boolean toBoolean(Double self) {
		return self != 0;
	}

	public Integer toInt(Double self) {
		return self.intValue();
	}

	public Long toLong(Double self) {
		return self.longValue();
	}

	public Float toFloat(Double self) {
		return self.floatValue();
	}

	public Double toDouble(Double self) {
		return self;
	}

	public Short toShort(Double self) {
		return self.shortValue();
	}

	public Byte toByte(Double self) {
		return self.byteValue();
	}

	public BigInteger toBigInteger(Double self) {
		return BigInteger.valueOf(self.longValue());
	}

	public BigDecimal toBigDecimal(Double self) {
		return new BigDecimal(self);
	}
}




