/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.ext.extensionmethod;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 针对 java.math.BigDecimal 的扩展方法
 *
 * 用法：
 * #if(value.toInt() == 123)
 */
public class BigDecimalExt {
    public Boolean toBoolean(BigDecimal self) {
        return self.compareTo(BigDecimal.ZERO) != 0;
    }

    public Integer toInt(BigDecimal self) {
        return self.intValue();
    }

    public Long toLong(BigDecimal self) {
        return self.longValue();
    }

    public Float toFloat(BigDecimal self) {
        return self.floatValue();
    }

    public Double toDouble(BigDecimal self) {
        return self.doubleValue();
    }

    public Short toShort(BigDecimal self) {
        return self.shortValue();
    }

    public Byte toByte(BigDecimal self) {
        return self.byteValue();
    }

    // BigDecimal.toBigInteger() 已存在
    // public BigInteger toBigInteger(BigDecimal self) {
    //     return self.toBigInteger();
    // }

    public BigDecimal toBigDecimal(BigDecimal self) {
        return self;
    }

    /**
     * 四舍五入
     * @param self BigDecimal 对象自身
     * @param newScale 设置返回值的小数位数
     */
    public BigDecimal halfUp(BigDecimal self, int newScale) {
        return self.setScale(newScale, RoundingMode.HALF_UP);
    }
}
