/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

import cn.aifei.enjoy.stat.Location;
import cn.aifei.enjoy.stat.ParseException;
import cn.aifei.enjoy.stat.Scope;

/**
 * Ternary
 */
public class Ternary extends Expr {

	private Expr cond;
	private Expr exprOne;
	private Expr exprTwo;

	/**
	 * cond ? exprOne : exprTwo
	 */
	public Ternary(Expr cond, Expr exprOne, Expr exprTwo, Location location) {
		if (cond == null || exprOne == null || exprTwo == null) {
			throw new ParseException("The parameter of ternary expression can not be blank", location);
		}
		this.cond = cond;
		this.exprOne = exprOne;
		this.exprTwo = exprTwo;
		this.location = location;
	}

	public Object eval(Scope scope) {
		return Logic.isTrue(cond.eval(scope)) ? exprOne.eval(scope) : exprTwo.eval(scope);
	}
}








