/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

import cn.aifei.enjoy.TemplateException;
import cn.aifei.enjoy.stat.Location;
import cn.aifei.enjoy.stat.ParseException;
import cn.aifei.enjoy.stat.Scope;
import java.lang.reflect.Field;

/**
 * StaticField : ID_list '::' ID
 * 动态获取静态变量值，变量值改变时仍可正确获取
 * 用法：cn.aifei.core.Const::JFINAL_VERSION
 */
public class StaticField extends Expr {

	private Class<?> clazz;
	private String fieldName;
	private Field field;

	public StaticField(String className, String fieldName, Location location) {
		try {
			this.clazz = Class.forName(className);
			this.fieldName = fieldName;
			this.field = clazz.getField(fieldName);
			this.location = location;
		} catch (Exception e) {
			throw new ParseException(e.getMessage(), location, e);
		}
	}

	public Object eval(Scope scope) {
		try {
			return field.get(null);
		} catch (Exception e) {
			throw new TemplateException(e.getMessage(), location, e);
		}
	}

	public String toString() {
		return clazz.getName() + "::" + fieldName;
	}
}







