/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

/**
 * NullMethodInfo
 *
 * 1：MethodKit.getMethod(...) 消除 instanceof 判断
 * 2：Method.exec(...) 消除 null 值判断
 */
public class NullMethodInfo extends MethodInfo {

	public static final NullMethodInfo me = new NullMethodInfo();

	public boolean notNull() {
		return false;
	}

	public Object invoke(Object target, Object... args) throws ReflectiveOperationException {
		throw new RuntimeException("The method invoke(Object, Object...) of NullMethodInfo should not be invoked");
	}
}

