/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

import cn.aifei.enjoy.stat.Scope;

/**
 * Id
 */
public class Id extends Expr {

	private final String id;

	public Id(String id) {
		this.id = id;
	}

	public String getId() {
		return id;
	}

	public Object eval(Scope scope) {
		return scope.get(id);
	}

	/**
	 * Id.toString() 后续版本不能变动，已有部分第三方依赖此方法
	 */
	public String toString() {
		return id;
	}
}


