/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

import cn.aifei.enjoy.TemplateException;
import cn.aifei.enjoy.stat.Location;
import cn.aifei.enjoy.stat.ParseException;
import cn.aifei.enjoy.stat.Scope;

/**
 * forCtrl : ID : expression
 * 		   | exprList? ';' expr? ';' exprList?
 *
 * 两种用法
 * 1：#for(id : list) #end
 *    #for(entry : map) #end
 *
 * 2：#for(init; cond; update) #end
 */
public class ForCtrl extends Expr {

	private String id;
	private Expr expr;

	private Expr init;
	private Expr cond;
	private Expr update;

	/**
	 * ID : expr
	 */
	public ForCtrl(Id id, Expr expr, Location location) {
		if (expr == null) {
			throw new ParseException("The iterator target of #for statement can not be null", location);
		}
		this.id = id.getId();
		this.expr = expr;
		this.init = null;
		this.cond = null;
		this.update = null;
		this.location = location;
	}

	/**
	 * exprList? ';' expr? ';' exprList?
	 */
	public ForCtrl(ExprList init, Expr cond, ExprList update, Location location) {
		this.init = init.getActualExpr();
		this.cond = cond;
		this.update = update.getActualExpr();
		this.id = null;
		this.expr = null;
		this.location = location;
	}

	public boolean isIterator() {
		return id != null;
	}

	public String getId() {
		return id;
	}

	public Expr getExpr() {
		return expr;
	}

	public Expr getInit() {
		return init;
	}

	public Expr getCond() {
		return cond;
	}

	public Expr getUpdate() {
		return update;
	}

	public Object eval(Scope scope) {
		throw new TemplateException("The eval(Scope scope) method can not be invoked", location);
	}
}


