/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

/**
 * FieldGetter 用于支持 target.field 表达式的取值，
 * 以及支持用户扩展自定义的 FieldGetter 实现方式
 */
public abstract class FieldGetter {

	/**
	 * 接管 target.fieldName 表达式，如果可以接管则返回接管对象，否则返回 null
	 * @param targetClass target.fieldName 表达式中 target 的 Class 类型
	 * @param fieldName target.fieldName 表达式中的 fieldName 部分
	 * @return 如果可以接管 targetClass.fieldName 则返回接管对象，否则返回 null
	 */
	public abstract FieldGetter takeOver(Class<?> targetClass, String fieldName);

	/**
	 * 获取 target.fieldName 表达式的值
	 * @param target 目标对象
	 * @param fieldName 字段名称
	 * @return target.fieldName 表达式的值
	 */
	public abstract Object get(Object target, String fieldName) throws Exception;

	/**
	 * 仅仅 NullFieldGetter 会覆盖此方法并返回 false
	 *
	 * 用于消除 FieldKit.getFieldGetter(...) 中的 instanceof 判断，
	 * 并且让 Map fieldGetterCache 的 value 值不必使用 Object 类型，
	 * 还消除了 Field.exec(...) 中的 null 值判断
	 */
	public boolean notNull() {
		return true;
	}
}







