/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr.ast;

import java.util.ArrayList;
import java.util.List;
import cn.aifei.enjoy.stat.Location;
import cn.aifei.enjoy.stat.ParseException;
import cn.aifei.enjoy.stat.Scope;

/**
 * Array
 *
 * 用法：
 * 1：[1, 2, 3]
 * 2：["a", 1, "b", 2, false, 3.14]
 */
public class Array extends Expr {

	private Expr[] exprList;

	public Array(Expr[] exprList, Location location) {
		if (exprList == null) {
			throw new ParseException("exprList can not be null", location);
		}
		this.exprList = exprList;
	}

	public Object eval(Scope scope) {
		List<Object> array = new ArrayListExt(exprList.length);
		for (Expr expr : exprList) {
			array.add(expr.eval(scope));
		}
		return array;
	}

	/**
	 * 支持 array.length 表达式
	 */
	@SuppressWarnings("serial")
	public static class ArrayListExt extends ArrayList<Object> {

		public ArrayListExt(int initialCapacity) {
			super(initialCapacity);
		}

		public Integer getLength() {
			return size();
		}
	}
}



