/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr;

/**
 * Tok
 */
class Tok {

	final Sym sym;
	private final String value;
	final int row;

	Tok(Sym sym, int row) {
		this(sym, sym.value(), row);
	}

	Tok(Sym exprSym, String value, int row) {
		if (exprSym == null || value == null) {
			throw new IllegalArgumentException("exprSym and value can not be null");
		}
		this.sym = exprSym;
		this.value = value;
		this.row = row;
	}

	String value() {
		return value;
	}

	public String toString() {
		return value;
	}

	void print() {
		System.out.print("[");
		System.out.print(row);
		System.out.print(", ");
		System.out.print(sym.value());
		System.out.print(", ");
		System.out.print(value());
		System.out.println("]");
	}
}





