/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy.expr;

/**
 * Sym
 */
public enum Sym {

	ASSIGN("="),

	DOT("."), RANGE(".."), COLON(":"), STATIC("::"), COMMA(","), SEMICOLON(";"),
	LPAREN("("), RPAREN(")"), LBRACK("["), RBRACK("]"), LBRACE("{"), RBRACE("}"),

	ADD("+"), SUB("-"), INC("++"), DEC("--"),
	MUL("*"), DIV("/"), MOD("%"),

	EQUAL("=="), NOTEQUAL("!="), LT("<"), LE("<="), GT(">"), GE(">="),

	NOT("!"), AND("&&"), OR("||"),

	QUESTION("?"),
	NULL_SAFE("??"),

	OPTIONAL_CHAIN("?."),

	ID("ID"),

	STR("STR"), TRUE("TRUE"), FALSE("FALSE"), NULL("NULL"),
	INT("INT"), LONG("LONG"), FLOAT("FLOAT"), DOUBLE("DOUBLE"),

	EOF("EOF");

	private final String value;

	private Sym(String value) {
		this.value = value;
	}

	public String value() {
		return value;
	}

	public String toString() {
		return value;
	}
}





