/**
 * Copyright (c) 2023 James Zhan 詹波 (zhanbocn@126.com)
 * Aifei Enjoy is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cn.aifei.enjoy;

import cn.aifei.enjoy.expr.ast.ExprList;
import cn.aifei.enjoy.stat.ast.Stat;

/**
 * Directive 供用户继承并扩展自定义指令，具体用法可以参考
 * cn.aifei.enjoy.ext.directive 包下面的例子
 */
public abstract class Directive extends Stat {

	/**
	 * 传递给指令的表达式列表
	 * 1：表达式列表可通过 exprList.eval(scope) 以及 exprList.evalExprList(scope) 进行求值
	 * 2:使用赋值表达式可实现参数传递功能
	 *
	 * <pre>
	 * 例如：#render("_hot.html", title="热门新闻", list=newsList)
	 * </pre>
	 */
	protected ExprList exprList;

	/**
	 * 具有 #end 结束符的指令内部嵌套的所有内容，调用 stat.exec(env, scope, writer)
	 * 即可执行指令内部嵌入所有指令与表达式，如果指令没有 #end 结束符，该属性无效
	 */
	protected Stat stat;

	/**
	 * 指令被解析时注入指令参数表达式列表，继承类可以通过覆盖此方法对参数长度和参数类型进行校验
	 */
	public void setExprList(ExprList exprList) {
		this.exprList = exprList;
	}

	/**
	 * 指令被解析时注入指令 body 内容，仅对于具有 #end 结束符的指令有效
	 */
	public void setStat(Stat stat) {
		this.stat = stat;
	}
}





