/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.decoder.BaseDecoder;
import cn.aghost.http.client.decoder.JsonDecoder;
import cn.aghost.http.client.encoder.BaseEncoder;
import cn.aghost.http.client.encoder.JsonEncoder;
import cn.aghost.http.client.object.EncodePayload;
import cn.aghost.http.client.object.HttpResponse;
import cn.aghost.http.client.utils.CodecAnnotationUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoUtils {
    private static final Logger log = LoggerFactory.getLogger(PojoUtils.class);
    private static Map<Class<?>, CodecAnnotationUtils.CodecPayload> codecMap;
    private static Class<? extends BaseEncoder> DEFAULT_ENCODER;
    private static Class<? extends BaseDecoder> DEFAULT_DECODER;

    public static synchronized void addObjectMapping(Class<?> objectClazz, CodecAnnotationUtils.CodecPayload codec) {
        codecMap.put(objectClazz, codec);
    }

    public static boolean checkPojoAnnotation(Class<?> clazz) {
        return codecMap.containsKey(clazz);
    }

    public static EncodePayload doEncode(Object data) throws IllegalAccessException, InvocationTargetException {
        Class<? extends BaseEncoder> encoder = PojoUtils.chooseEncoder(data);
        Method encoderMethod = null;
        for (Method method : encoder.getMethods()) {
            if (!method.getName().equals("encode")) continue;
            encoderMethod = method;
            break;
        }
        if (encoderMethod == null) {
            throw new IllegalAccessException();
        }
        EncodePayload encode = (EncodePayload)encoderMethod.invoke(null, data);
        return encode;
    }

    public static <T> T doDecode(Class<T> clazz, HttpResponse resp) throws IllegalAccessException, InvocationTargetException {
        Class<BaseDecoder> decoder = PojoUtils.chooseDecoder(clazz);
        Method decodeMethod = null;
        for (Method method : decoder.getMethods()) {
            if (!method.getName().equals("decode")) continue;
            decodeMethod = method;
            break;
        }
        if (decodeMethod == null) {
            throw new IllegalAccessException();
        }
        Object result = decodeMethod.invoke(null, clazz, resp);
        return (T)result;
    }

    private static Class<? extends BaseEncoder> chooseEncoder(Object data) {
        if (!PojoUtils.checkPojoAnnotation(data.getClass())) {
            return DEFAULT_ENCODER;
        }
        return codecMap.get(data.getClass()).getEncoder();
    }

    private static <T> Class<? extends BaseDecoder> chooseDecoder(Class<T> clazz) {
        if (!PojoUtils.checkPojoAnnotation(clazz)) {
            return DEFAULT_DECODER;
        }
        return codecMap.get(clazz).getDecoder();
    }

    static {
        DEFAULT_ENCODER = JsonEncoder.class;
        DEFAULT_DECODER = JsonDecoder.class;
        try {
            codecMap = CodecAnnotationUtils.searchAnnotation();
        }
        catch (Exception e) {
            log.error("init codec fail,{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            System.exit(111);
        }
    }
}

