/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.object.SchemesEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpDataUtils {
    public static String buildUrl(@NotNull SchemesEnum scheme, @NotNull String host, @NotNull String path, @Nullable Map<String, List<String>> queryParam) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(scheme.toString()).host(host).addPathSegment(path);
        if (queryParam != null) {
            queryParam.forEach((k, v) -> {
                if (v != null) {
                    v.forEach(val -> builder.addQueryParameter(k, val));
                }
            });
        }
        return builder.build().toString();
    }

    @Nullable
    public static Map<String, List<String>> decodeQueryString(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            httpUrl.queryParameterNames().forEach(name -> {
                try {
                    if (StringUtils.isNotBlank((CharSequence)name)) {
                        List valList = httpUrl.queryParameterValues(name);
                        paramMap.put((String)name, valList);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        if (paramMap.size() == 0) {
            return null;
        }
        return paramMap;
    }
}

