/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.annotation.HttpCodec;
import cn.aghost.http.client.decoder.BaseDecoder;
import cn.aghost.http.client.decoder.JsonDecoder;
import cn.aghost.http.client.encoder.BaseEncoder;
import cn.aghost.http.client.encoder.JsonEncoder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecAnnotationUtils {
    private static final Logger log = LoggerFactory.getLogger(CodecAnnotationUtils.class);
    private static volatile boolean reflectionsLogCovered = false;

    private static synchronized void coverReflectionsLog() throws NotFoundException, CannotCompileException {
        if (reflectionsLogCovered) {
            return;
        }
        ClassPool pool = new ClassPool(true);
        CtClass ctClass = pool.getCtClass("org.reflections.util.Utils");
        CtMethod m = ctClass.getDeclaredMethod("findLogger");
        m.setBody("return null;");
        ctClass.toClass();
        ctClass.detach();
        reflectionsLogCovered = true;
    }

    public static synchronized void setReflectionsLogCovered(boolean b) {
        reflectionsLogCovered = b;
    }

    public static Map<Class<?>, CodecPayload> searchAnnotation() throws NoSuchFieldException, IllegalAccessException, NotFoundException, CannotCompileException {
        CodecAnnotationUtils.coverReflectionsLog();
        ConcurrentHashMap codecMap = new ConcurrentHashMap();
        ClassLoader contextClassLoader = ClasspathHelper.contextClassLoader();
        ClassLoader staticClassLoader = ClasspathHelper.staticClassLoader();
        Class<ClassLoader> classLoaderClass = ClassLoader.class;
        Field packages = classLoaderClass.getDeclaredField("packages");
        packages.setAccessible(true);
        ConcurrentHashMap packageContext = (ConcurrentHashMap)packages.get(contextClassLoader);
        ConcurrentHashMap packageStatic = (ConcurrentHashMap)packages.get(staticClassLoader);
        ArrayList<Object> urlStrList = new ArrayList<Object>();
        for (String s : packageContext.keySet()) {
            if (s.startsWith("org.junit") || s.startsWith("junit") || s.startsWith("retrofit2") || urlStrList.contains(s)) continue;
            urlStrList.add(s);
        }
        for (Object k : packageStatic.keySet()) {
            if (urlStrList.contains(k)) continue;
            urlStrList.add(k);
        }
        ArrayList urls = new ArrayList();
        for (String string : urlStrList) {
            urls.addAll(ClasspathHelper.forPackage((String)string, (ClassLoader[])new ClassLoader[0]));
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(urls).addScanners(new Scanner[]{new SubTypesScanner(true), new TypeAnnotationsScanner()});
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(HttpCodec.class);
        for (Class c : typesAnnotatedWith) {
            HttpCodec annotation = c.getAnnotation(HttpCodec.class);
            CodecPayload codecPayload = new CodecPayload();
            codecPayload.setDecoder(annotation.decoder());
            codecPayload.setEncoder(annotation.encoder());
            codecMap.put(c, codecPayload);
        }
        CodecPayload jsonCodec = new CodecPayload();
        jsonCodec.setEncoder(JsonEncoder.class);
        jsonCodec.setDecoder(JsonDecoder.class);
        codecMap.put(JSON.class, jsonCodec);
        codecMap.put(JSONArray.class, jsonCodec);
        codecMap.put(JSONObject.class, jsonCodec);
        return codecMap;
    }

    public static class CodecPayload {
        private Class<? extends BaseDecoder> decoder;
        private Class<? extends BaseEncoder> encoder;

        public Class<? extends BaseDecoder> getDecoder() {
            return this.decoder;
        }

        public Class<? extends BaseEncoder> getEncoder() {
            return this.encoder;
        }

        public void setDecoder(Class<? extends BaseDecoder> decoder) {
            this.decoder = decoder;
        }

        public void setEncoder(Class<? extends BaseEncoder> encoder) {
            this.encoder = encoder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodecPayload)) {
                return false;
            }
            CodecPayload other = (CodecPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<? extends BaseDecoder> this$decoder = this.getDecoder();
            Class<? extends BaseDecoder> other$decoder = other.getDecoder();
            if (this$decoder == null ? other$decoder != null : !this$decoder.equals(other$decoder)) {
                return false;
            }
            Class<? extends BaseEncoder> this$encoder = this.getEncoder();
            Class<? extends BaseEncoder> other$encoder = other.getEncoder();
            return !(this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CodecPayload;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends BaseDecoder> $decoder = this.getDecoder();
            result = result * 59 + ($decoder == null ? 43 : $decoder.hashCode());
            Class<? extends BaseEncoder> $encoder = this.getEncoder();
            result = result * 59 + ($encoder == null ? 43 : $encoder.hashCode());
            return result;
        }

        public String toString() {
            return "CodecAnnotationUtils.CodecPayload(decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ")";
        }
    }
}

