/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.exceptions.ClientNotFoundException;
import cn.aghost.http.client.object.ClientConfig;
import cn.aghost.http.client.object.HttpCallback;
import cn.aghost.http.client.object.HttpResponse;
import cn.aghost.http.client.object.LogLevelEnum;
import cn.aghost.http.client.utils.HttpClientUtil;
import cn.aghost.http.client.utils.HttpDataUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.UUID;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttpExecutor {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpExecutor.class);
    private static volatile boolean logFlag = false;
    private static volatile LogLevelEnum logLevel = LogLevelEnum.info;
    private static volatile boolean autoDecodeBody = false;

    public static boolean isAutoDecodeBody() {
        return autoDecodeBody;
    }

    public static synchronized void setAutoDecodeBody(boolean autoDecodeBody) {
        BaseHttpExecutor.autoDecodeBody = autoDecodeBody;
    }

    public static LogLevelEnum getLogLevel() {
        return logLevel;
    }

    public static synchronized void setLogLevel(LogLevelEnum logLevel) {
        BaseHttpExecutor.logLevel = logLevel;
    }

    public static boolean getLogFlag() {
        return logFlag;
    }

    public static synchronized void setLogFlag(boolean logFlag) {
        BaseHttpExecutor.logFlag = logFlag;
    }

    private static void execLog(String format, Object ... arg) {
        switch (logLevel) {
            case trace: {
                log.trace(format, arg);
                break;
            }
            case debug: {
                log.debug(format, arg);
                break;
            }
            case info: {
                log.info(format, arg);
                break;
            }
            case warn: {
                log.warn(format, arg);
                break;
            }
            case error: {
                log.error(format, arg);
            }
        }
    }

    private static void execLog(JSON data) {
        String logData = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNonStringKeyAsString, SerializerFeature.WriteDateUseDateFormat});
        switch (logLevel) {
            case trace: {
                log.trace(logData);
                break;
            }
            case debug: {
                log.debug(logData);
                break;
            }
            case info: {
                log.info(logData);
                break;
            }
            case warn: {
                log.warn(logData);
                break;
            }
            case error: {
                log.error(logData);
            }
        }
    }

    public static Request.Builder buildBaseReq() {
        return new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build());
    }

    public static HttpResponse executeGet(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig) throws IOException, ClientNotFoundException {
        HttpResponse httpResponse;
        block13: {
            OkHttpClient client;
            String reqId = null;
            boolean logFlag = BaseHttpExecutor.logFlag;
            if (logFlag) {
                reqId = UUID.randomUUID().toString();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("method", (Object)"GET");
                jsonObject.put("reqId", (Object)reqId);
                jsonObject.put("url", (Object)url);
                jsonObject.put("query", HttpDataUtils.decodeQueryString(url));
                jsonObject.put("headers", (Object)headers);
                jsonObject.put("clientInfo", (Object)clientConfig);
                jsonObject.put("state", (Object)"preExec");
                BaseHttpExecutor.execLog((JSON)jsonObject);
            }
            if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
                throw new ClientNotFoundException();
            }
            Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
            if (headers != null && headers.size() > 0) {
                builder.headers(headers);
            }
            Request req = builder.build();
            Response rsp = client.newCall(req).execute();
            try {
                HttpResponse response = new HttpResponse(rsp);
                if (logFlag) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("reqId", (Object)reqId);
                    jsonObject.put("resp", (Object)response);
                    jsonObject.put("state", (Object)"execResult");
                    BaseHttpExecutor.execLog((JSON)jsonObject);
                }
                httpResponse = response;
                if (rsp == null) break block13;
            }
            catch (Throwable response) {
                try {
                    if (rsp != null) {
                        try {
                            rsp.close();
                        }
                        catch (Throwable throwable) {
                            response.addSuppressed(throwable);
                        }
                    }
                    throw response;
                }
                catch (IOException e) {
                    if (logFlag) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("reqId", (Object)reqId);
                        jsonObject.put("ex", (Object)e);
                        jsonObject.put("state", (Object)"execEx");
                        BaseHttpExecutor.execLog((JSON)jsonObject);
                    }
                    throw e;
                }
            }
            rsp.close();
        }
        return httpResponse;
    }

    public static HttpResponse executeWithBody(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig) throws IOException, ClientNotFoundException {
        HttpResponse httpResponse;
        block15: {
            OkHttpClient client;
            if (contentType == null) {
                contentType = MediaType.parse((String)"text/plan; charset=utf-8");
            }
            if (body == null) {
                body = "".getBytes();
            }
            String reqId = null;
            boolean logFlag = BaseHttpExecutor.logFlag;
            if (logFlag) {
                reqId = UUID.randomUUID().toString();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("reqId", (Object)reqId);
                jsonObject.put("method", (Object)method);
                jsonObject.put("url", (Object)url);
                jsonObject.put("query", HttpDataUtils.decodeQueryString(url));
                jsonObject.put("headers", (Object)headers);
                jsonObject.put("clientInfo", (Object)clientConfig);
                jsonObject.put("body", (Object)body);
                jsonObject.put("contentType", (Object)contentType);
                jsonObject.put("state", (Object)"preExec");
                BaseHttpExecutor.execLog((JSON)jsonObject);
            }
            if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
                throw new ClientNotFoundException();
            }
            Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
            if (headers != null && headers.size() > 0) {
                builder.headers(headers);
            }
            Request req = builder.build();
            Response rsp = client.newCall(req).execute();
            try {
                HttpResponse response = new HttpResponse(rsp);
                if (logFlag) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("reqId", (Object)reqId);
                    jsonObject.put("resp", (Object)response);
                    jsonObject.put("state", (Object)"execResult");
                    BaseHttpExecutor.execLog((JSON)jsonObject);
                }
                httpResponse = response;
                if (rsp == null) break block15;
            }
            catch (Throwable response) {
                try {
                    if (rsp != null) {
                        try {
                            rsp.close();
                        }
                        catch (Throwable throwable) {
                            response.addSuppressed(throwable);
                        }
                    }
                    throw response;
                }
                catch (IOException e) {
                    if (logFlag) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("reqId", (Object)reqId);
                        jsonObject.put("ex", (Object)e);
                        jsonObject.put("state", (Object)"execEx");
                        BaseHttpExecutor.execLog((JSON)jsonObject);
                    }
                    throw e;
                }
            }
            rsp.close();
        }
        return httpResponse;
    }

    public static void executeGetAsync(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig, @NotNull HttpCallback httpCallback) throws ClientNotFoundException {
        OkHttpClient client;
        String reqId = null;
        boolean logFlag = BaseHttpExecutor.logFlag;
        if (logFlag) {
            reqId = UUID.randomUUID().toString();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("reqId", (Object)reqId);
            jsonObject.put("method", (Object)"GET");
            jsonObject.put("url", (Object)url);
            jsonObject.put("query", HttpDataUtils.decodeQueryString(url));
            jsonObject.put("headers", (Object)headers);
            jsonObject.put("clientInfo", (Object)clientConfig);
            jsonObject.put("state", (Object)"preExec");
            BaseHttpExecutor.execLog((JSON)jsonObject);
        }
        if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
            throw new ClientNotFoundException();
        }
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(httpCallback, client, req, logFlag, reqId);
    }

    public static void executeWithBodyAsync(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull HttpCallback httpCallback) throws ClientNotFoundException {
        OkHttpClient client;
        if (contentType == null) {
            contentType = MediaType.parse((String)"text/plan; charset=utf-8");
        }
        if (body == null) {
            body = "".getBytes();
        }
        String reqId = null;
        boolean logFlag = BaseHttpExecutor.logFlag;
        if (logFlag) {
            reqId = UUID.randomUUID().toString();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("reqId", (Object)reqId);
            jsonObject.put("method", (Object)method);
            jsonObject.put("url", (Object)url);
            jsonObject.put("query", HttpDataUtils.decodeQueryString(url));
            jsonObject.put("headers", (Object)headers);
            jsonObject.put("clientInfo", (Object)clientConfig);
            jsonObject.put("body", (Object)body);
            jsonObject.put("contentType", (Object)contentType);
            jsonObject.put("state", (Object)"preExec");
            BaseHttpExecutor.execLog((JSON)jsonObject);
        }
        if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
            throw new ClientNotFoundException();
        }
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(httpCallback, client, req, logFlag, reqId);
    }

    public static void executeGetAsync(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig, @NotNull Callback callback) throws ClientNotFoundException {
        OkHttpClient client;
        String reqId = null;
        boolean logFlag = BaseHttpExecutor.logFlag;
        if (logFlag) {
            reqId = UUID.randomUUID().toString();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("reqId", (Object)reqId);
            jsonObject.put("method", (Object)"GET");
            jsonObject.put("url", (Object)url);
            jsonObject.put("query", HttpDataUtils.decodeQueryString(url));
            jsonObject.put("headers", (Object)headers);
            jsonObject.put("clientInfo", (Object)clientConfig);
            jsonObject.put("state", (Object)"preExec");
            BaseHttpExecutor.execLog((JSON)jsonObject);
        }
        if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
            throw new ClientNotFoundException();
        }
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(callback, client, req);
    }

    public static void executeWithBodyAsync(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull Callback callback) throws ClientNotFoundException {
        OkHttpClient client;
        if (contentType == null) {
            contentType = MediaType.parse((String)"text/plan; charset=utf-8");
        }
        if (body == null) {
            body = "".getBytes();
        }
        if ((client = HttpClientUtil.getClient(clientConfig)) == null) {
            throw new ClientNotFoundException();
        }
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(callback, client, req);
    }

    public static void executeAsync(final @NotNull HttpCallback httpCallback, @NotNull OkHttpClient client, @NotNull Request req, final boolean logFlag, final @Nullable String reqId) {
        client.newCall(req).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                if (logFlag) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("reqId", (Object)reqId);
                    jsonObject.put("ex", (Object)e);
                    jsonObject.put("state", (Object)"execEx");
                    BaseHttpExecutor.execLog((JSON)jsonObject);
                }
                httpCallback.onFailure(call, e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                HttpResponse rsp = new HttpResponse(response);
                if (logFlag) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("reqId", (Object)reqId);
                    jsonObject.put("resp", (Object)rsp);
                    jsonObject.put("state", (Object)"execResult");
                    BaseHttpExecutor.execLog((JSON)jsonObject);
                }
                httpCallback.onSuccess(call, rsp);
            }
        });
    }

    public static void executeAsync(@NotNull Callback callback, @NotNull OkHttpClient client, @NotNull Request req) {
        client.newCall(req).enqueue(callback);
    }
}

