/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.object;

import cn.aghost.http.client.utils.BaseHttpExecutor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class HttpResponse {
    private Protocol protocol;
    private int code;
    private Headers headers;
    private byte[] body;
    private boolean successful;
    private boolean redirect;
    @Nullable
    private String contentType;
    @Nullable
    private String charset;
    @Nullable
    private String bodyString;

    public HttpResponse(Response rsp) throws IOException {
        this.protocol = rsp.protocol();
        this.code = rsp.code();
        this.headers = rsp.headers();
        this.body = rsp.body().bytes();
        this.successful = rsp.isSuccessful();
        this.redirect = rsp.isRedirect();
        this.headers.names().forEach(name -> {
            if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)name) && "content-type".equals(name.toLowerCase().trim())) {
                String value = this.headers.get(name);
                this.contentType = value.trim().toLowerCase();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)this.contentType)) {
            String[] arr;
            boolean isUtf8Json = false;
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"application/json", (CharSequence[])new CharSequence[]{this.contentType})) {
                isUtf8Json = true;
            }
            if (!isUtf8Json && StringUtils.contains((CharSequence)this.contentType, (CharSequence)";") && (arr = this.contentType.split(";")).length == 2) {
                String tmpContentType = arr[0].trim();
                String tmpCharset = arr[1].trim();
                if (tmpCharset.toLowerCase().contains("charset=")) {
                    tmpCharset = tmpCharset.replaceAll("charset=", "").trim();
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)"application/json", (CharSequence[])new CharSequence[]{tmpContentType}) && StringUtils.equalsAnyIgnoreCase((CharSequence)"UTF-8", (CharSequence[])new CharSequence[]{tmpCharset})) {
                    isUtf8Json = true;
                }
            }
            if (isUtf8Json) {
                this.contentType = "application/json";
                this.charset = "UTF-8";
            }
            if (BaseHttpExecutor.isAutoDecodeBody()) {
                this.bodyString = this.autoDecodeBody();
            }
        }
    }

    public String autoDecodeBody() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.bodyString)) {
                return this.bodyString;
            }
            if (StringUtils.isNotBlank((CharSequence)this.charset)) {
                Charset charset = Charset.forName(this.charset);
                return new String(this.body, charset);
            }
            return new String(this.body);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getCode() {
        return this.code;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @Nullable
    public String getBodyString() {
        return this.bodyString;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    public void setCharset(@Nullable String charset) {
        this.charset = charset;
    }

    public void setBodyString(@Nullable String bodyString) {
        this.bodyString = bodyString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.isRedirect() != other.isRedirect()) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$bodyString = this.getBodyString();
        String other$bodyString = other.getBodyString();
        return !(this$bodyString == null ? other$bodyString != null : !this$bodyString.equals(other$bodyString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + (this.isRedirect() ? 79 : 97);
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $bodyString = this.getBodyString();
        result = result * 59 + ($bodyString == null ? 43 : $bodyString.hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(protocol=" + this.getProtocol() + ", code=" + this.getCode() + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ", successful=" + this.isSuccessful() + ", redirect=" + this.isRedirect() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", bodyString=" + this.getBodyString() + ")";
    }

    public HttpResponse() {
    }

    public HttpResponse(Protocol protocol, int code, Headers headers, byte[] body, boolean successful, boolean redirect, @Nullable String contentType, @Nullable String charset, @Nullable String bodyString) {
        this.protocol = protocol;
        this.code = code;
        this.headers = headers;
        this.body = body;
        this.successful = successful;
        this.redirect = redirect;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyString = bodyString;
    }
}

