/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client;

import cn.aghost.http.client.exceptions.ClientNotFoundException;
import cn.aghost.http.client.object.ClientConfig;
import cn.aghost.http.client.object.EncodePayload;
import cn.aghost.http.client.object.HttpCallback;
import cn.aghost.http.client.object.HttpResponse;
import cn.aghost.http.client.utils.BaseHttpExecutor;
import cn.aghost.http.client.utils.PojoUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Put {
    public static <T> T doPut(@NotNull String url, @Nullable String tag, @NotNull Object param, Class<T> clazz) throws InvocationTargetException, IllegalAccessException, IOException, ClientNotFoundException {
        return Put.doPut(url, tag, null, param, null, clazz);
    }

    public static <T> T doPut(@NotNull String url, @Nullable String tag, @Nullable Headers headers, @NotNull Object param, Class<T> clazz) throws InvocationTargetException, IllegalAccessException, IOException, ClientNotFoundException {
        return Put.doPut(url, tag, headers, param, null, clazz);
    }

    public static <T> T doPut(@NotNull String url, @Nullable String tag, @Nullable Headers headers, @NotNull Object param, @Nullable ClientConfig clientConfig, Class<T> clazz) throws InvocationTargetException, IllegalAccessException, IOException, ClientNotFoundException {
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
        }
        clientConfig.setTag(tag);
        EncodePayload encodePayload = PojoUtils.doEncode(param);
        HttpResponse httpResponse = Put.doPut(url, headers, encodePayload.getBody(), encodePayload.getContentType(), clientConfig);
        return PojoUtils.doDecode(clazz, httpResponse);
    }

    public static HttpResponse doPut(@NotNull String url, @Nullable byte[] body, @Nullable MediaType contentType) throws IOException, ClientNotFoundException {
        return Put.doPut(url, null, body, contentType, null);
    }

    public static HttpResponse doPut(@NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType) throws IOException, ClientNotFoundException {
        return Put.doPut(url, headers, body, contentType, null);
    }

    public static HttpResponse doPut(@NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig) throws IOException, ClientNotFoundException {
        return BaseHttpExecutor.executeWithBody("PUT", url, headers, body, contentType, clientConfig);
    }

    public static void doPutAsync(@NotNull String url, @Nullable byte[] body, @Nullable MediaType contentType, @NotNull HttpCallback httpCallback) throws ClientNotFoundException {
        Put.doPutAsync(url, null, body, contentType, null, httpCallback);
    }

    public static void doPutAsync(@NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @NotNull HttpCallback httpCallback) throws ClientNotFoundException {
        Put.doPutAsync(url, headers, body, contentType, null, httpCallback);
    }

    public static void doPutAsync(@NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull HttpCallback httpCallback) throws ClientNotFoundException {
        BaseHttpExecutor.executeWithBodyAsync("PUT", url, headers, body, contentType, clientConfig, httpCallback);
    }

    public static void doPutAsync(@NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull Callback callback) throws ClientNotFoundException {
        BaseHttpExecutor.executeWithBodyAsync("PUT", url, headers, body, contentType, clientConfig, callback);
    }
}

