/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.exceptions.DuplicateHttpClientNameException;
import cn.aghost.http.client.exceptions.HttpClientNotFoundException;
import cn.aghost.http.client.object.ClientConfig;
import cn.aghost.http.client.utils.LockWrapper;
import java.net.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    public static final String DEFAULT_CLIENT_NAME = "default_client";
    public static final int DEFAULT_MAX_REQUEST = 500;
    public static final int DEFAULT_MAX_REQUEST_PER_HOST = 10;
    public static final int DEFAULT_TIMEOUT = 30;
    public static final boolean DEFAULT_FORCE_HTTP1 = false;
    public static final Proxy DEFAULT_PROXY = null;
    private static Map<String, OkHttpClient> clientMap = new ConcurrentHashMap<String, OkHttpClient>();
    private static Lock defaultClientLock = new ReentrantLock();

    public static String buildClientName(@Nullable ClientConfig clientConfig) {
        if (clientConfig == null || clientConfig.getMaxRequest() < 1 || clientConfig.getMaxRequestPerHost() < 1 || clientConfig.getReadTimeout() < 1 || clientConfig.getConnectTimeout() < 1 || clientConfig.getWriteTimeout() < 1) {
            return DEFAULT_CLIENT_NAME;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clientConfig.getMaxRequest());
        sb.append("-");
        sb.append(clientConfig.getMaxRequestPerHost());
        sb.append("-");
        sb.append(clientConfig.getReadTimeout());
        sb.append("-");
        sb.append(clientConfig.getConnectTimeout());
        sb.append("-");
        sb.append(clientConfig.getWriteTimeout());
        sb.append("-");
        sb.append(clientConfig.isForceHttp1());
        return sb.toString();
    }

    public static OkHttpClient getClient(@Nullable ClientConfig clientConfig) {
        String clientName = HttpClientUtil.buildClientName(clientConfig);
        return DEFAULT_CLIENT_NAME.equals(clientName) ? HttpClientUtil.getClient() : HttpClientUtil.getClient(clientName, clientConfig);
    }

    public static OkHttpClient getClient() {
        if (!clientMap.containsKey(DEFAULT_CLIENT_NAME)) {
            try (LockWrapper l = new LockWrapper(defaultClientLock);){
                l.lock();
                HttpClientUtil.createClient();
            }
            catch (DuplicateHttpClientNameException duplicateHttpClientNameException) {
                // empty catch block
            }
        }
        return clientMap.get(DEFAULT_CLIENT_NAME);
    }

    public static OkHttpClient getClient(@NotNull String clientName) throws HttpClientNotFoundException {
        if (!clientMap.containsKey(clientName)) {
            throw new HttpClientNotFoundException();
        }
        return clientMap.get(clientName);
    }

    public static OkHttpClient getClient(@NotNull String clientName, @NotNull ClientConfig clientConfig) {
        if (!clientMap.containsKey(clientName)) {
            try {
                HttpClientUtil.createClient(clientName, clientConfig);
            }
            catch (DuplicateHttpClientNameException duplicateHttpClientNameException) {
                // empty catch block
            }
        }
        return clientMap.get(clientName);
    }

    public static synchronized void createClient(String clientName, ClientConfig clientConfig) throws DuplicateHttpClientNameException {
        log.debug("create client({}),{}", (Object)clientName, (Object)clientConfig.toString());
        if (clientMap.containsKey(clientName)) {
            throw new DuplicateHttpClientNameException();
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(clientConfig.getMaxRequest());
        dispatcher.setMaxRequestsPerHost(clientConfig.getMaxRequestPerHost());
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.readTimeout((long)clientConfig.getReadTimeout(), TimeUnit.SECONDS).connectTimeout((long)clientConfig.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout((long)clientConfig.getWriteTimeout(), TimeUnit.SECONDS).dispatcher(dispatcher).protocols(clientConfig.isForceHttp1() ? Arrays.asList(Protocol.HTTP_1_1) : Arrays.asList(Protocol.HTTP_1_1, Protocol.HTTP_2));
        if (clientConfig.getProxy() != null) {
            builder.proxy(clientConfig.getProxy());
        }
        clientMap.put(clientName, builder.build());
    }

    private static void createClient() throws DuplicateHttpClientNameException {
        ClientConfig clientConfig = new ClientConfig(500, 10, 30, 30, 30, false, DEFAULT_PROXY);
        HttpClientUtil.createClient(DEFAULT_CLIENT_NAME, clientConfig);
    }
}

