/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.utils;

import cn.aghost.http.client.object.ClientConfig;
import cn.aghost.http.client.object.HttpCallback;
import cn.aghost.http.client.object.HttpResponse;
import cn.aghost.http.client.utils.HttpClientUtil;
import java.io.IOException;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseHttpExecutor {
    public static Request.Builder buildBaseReq() {
        return new Request.Builder().cacheControl(new CacheControl.Builder().noCache().build());
    }

    public static HttpResponse executeWithBody(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig) throws IOException {
        if (contentType == null) {
            contentType = MediaType.parse((String)"text/plan; charset=utf-8");
        }
        if (body == null) {
            body = "".getBytes();
        }
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        try (Response rsp = client.newCall(req).execute();){
            HttpResponse httpResponse = new HttpResponse(rsp);
            return httpResponse;
        }
    }

    public static void executeWithBodyAsync(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull HttpCallback httpCallback) {
        if (contentType == null) {
            contentType = MediaType.parse((String)"text/plan; charset=utf-8");
        }
        if (body == null) {
            body = "".getBytes();
        }
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(httpCallback, client, req);
    }

    public static void executeWithBodyAsync(@NotNull String method, @NotNull String url, @Nullable Headers headers, @Nullable byte[] body, @Nullable MediaType contentType, @Nullable ClientConfig clientConfig, @NotNull Callback callback) {
        if (contentType == null) {
            contentType = MediaType.parse((String)"text/plan; charset=utf-8");
        }
        if (body == null) {
            body = "".getBytes();
        }
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).method(method, RequestBody.create((MediaType)contentType, (byte[])body));
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(callback, client, req);
    }

    public static void executeAsync(final @NotNull HttpCallback httpCallback, @NotNull OkHttpClient client, @NotNull Request req) {
        client.newCall(req).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                httpCallback.onFailure(call, e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                httpCallback.onSuccess(call, new HttpResponse(response));
            }
        });
    }

    public static void executeAsync(@NotNull Callback callback, @NotNull OkHttpClient client, @NotNull Request req) {
        client.newCall(req).enqueue(callback);
    }
}

