/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client.object;

import java.io.IOException;
import java.util.Arrays;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class HttpResponse {
    private Protocol protocol;
    private int code;
    private Headers headers;
    private byte[] body;
    private boolean successful;
    private boolean redirect;
    @Nullable
    private String contentType;
    @Nullable
    private String charset;

    public HttpResponse(Response rsp) throws IOException {
        String[] arr;
        this.protocol = rsp.protocol();
        this.code = rsp.code();
        this.headers = rsp.headers();
        this.body = rsp.body().bytes();
        this.successful = rsp.isSuccessful();
        this.redirect = rsp.isRedirect();
        this.headers.names().forEach(name -> {
            if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)name) && "content-type".equals(name.toLowerCase().trim())) {
                String value = this.headers.get(name);
                this.contentType = value.trim().toLowerCase();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)this.contentType) && StringUtils.contains((CharSequence)this.contentType, (CharSequence)"; ") && (arr = this.contentType.split("; ")).length == 2) {
            this.contentType = arr[0].trim();
            this.charset = arr[1].replaceAll("charset=", "").trim();
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getCode() {
        return this.code;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getCharset() {
        return this.charset;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    public void setCharset(@Nullable String charset) {
        this.charset = charset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Protocol this$protocol = this.getProtocol();
        Protocol other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Headers this$headers = this.getHeaders();
        Headers other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.isRedirect() != other.isRedirect()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Protocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        result = result * 59 + this.getCode();
        Headers $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        result = result * 59 + (this.isRedirect() ? 79 : 97);
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(protocol=" + this.getProtocol() + ", code=" + this.getCode() + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ", successful=" + this.isSuccessful() + ", redirect=" + this.isRedirect() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ")";
    }

    public HttpResponse() {
    }

    public HttpResponse(Protocol protocol, int code, Headers headers, byte[] body, boolean successful, boolean redirect, @Nullable String contentType, @Nullable String charset) {
        this.protocol = protocol;
        this.code = code;
        this.headers = headers;
        this.body = body;
        this.successful = successful;
        this.redirect = redirect;
        this.contentType = contentType;
        this.charset = charset;
    }
}

