/*
 * Decompiled with CFR 0.152.
 */
package cn.aghost.http.client;

import cn.aghost.http.client.object.ClientConfig;
import cn.aghost.http.client.object.HttpCallback;
import cn.aghost.http.client.object.HttpResponse;
import cn.aghost.http.client.utils.BaseHttpExecutor;
import cn.aghost.http.client.utils.HttpClientUtil;
import java.io.IOException;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Get {
    public static HttpResponse doGet(@NotNull String url) throws IOException {
        return Get.doGet(url, null, null);
    }

    public static HttpResponse doGet(@NotNull String url, @Nullable Headers headers) throws IOException {
        return Get.doGet(url, headers, null);
    }

    public static HttpResponse doGet(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig) throws IOException {
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        try (Response rsp = client.newCall(req).execute();){
            HttpResponse httpResponse = new HttpResponse(rsp);
            return httpResponse;
        }
    }

    public static void doGetAsync(@NotNull String url, @NotNull HttpCallback httpCallback) {
        Get.doGetAsync(url, null, null, httpCallback);
    }

    public static void doGetAsync(@NotNull String url, @Nullable Headers headers, @NotNull HttpCallback httpCallback) {
        Get.doGetAsync(url, headers, null, httpCallback);
    }

    public static void doGetAsync(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig, @NotNull HttpCallback httpCallback) {
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(httpCallback, client, req);
    }

    public static void doGetAsync(@NotNull String url, @Nullable Headers headers, @Nullable ClientConfig clientConfig, @NotNull Callback callback) {
        OkHttpClient client = HttpClientUtil.getClient(clientConfig);
        Request.Builder builder = BaseHttpExecutor.buildBaseReq().url(url).get();
        if (headers != null && headers.size() > 0) {
            builder.headers(headers);
        }
        Request req = builder.build();
        BaseHttpExecutor.executeAsync(callback, client, req);
    }
}

