/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.velocity.message;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TabBuilder {
    private ProxyServer server;
    private CommandSource target = null;
    private final List<String> list = new ArrayList<String>();

    public TabBuilder(ProxyServer server, CommandSource source) {
        this.server = server;
        this.target = source;
    }

    public TabBuilder(ProxyServer server) {
        this.server = server;
    }

    public TabBuilder() {
        this(null, null);
    }

    public CommandSource target() {
        return this.target;
    }

    public TabBuilder target(CommandSource target) {
        this.target = target;
        return this;
    }

    public ProxyServer server() {
        return this.server;
    }

    public TabBuilder server(ProxyServer server) {
        this.server = server;
        return this;
    }

    public TabBuilder add(String ... items) {
        this.list.addAll(Arrays.asList(items));
        return this;
    }

    public TabBuilder add(String prefix, String ... items) {
        for (String item : items) {
            if (!item.startsWith(prefix)) continue;
            this.list.add(item);
        }
        return this;
    }

    public TabBuilder players() {
        if (this.server == null) {
            throw new NullPointerException("No proxy server instance provided");
        }
        for (Player p : this.server.getAllPlayers()) {
            this.list.add(p.getUsername());
        }
        return this;
    }

    public TabBuilder players(ServerConnection server) {
        if (server == null) {
            throw new NullPointerException("No proxy server instance provided");
        }
        this.server.getAllPlayers().parallelStream().filter(p -> Objects.equals(p.getCurrentServer().orElse(null), server)).forEach(p -> this.list.add(p.getUsername()));
        return this;
    }

    public TabBuilder players(String prefix) {
        if (this.server == null) {
            throw new NullPointerException("No proxy server instance provided");
        }
        for (Player p : this.server.getAllPlayers()) {
            if (!p.getUsername().startsWith(prefix)) continue;
            this.list.add(p.getUsername());
        }
        return this;
    }

    public TabBuilder players(ProxyServer server, String prefix) {
        if (server == null) {
            throw new NullPointerException("No proxy server instance provided");
        }
        this.list.addAll(this.server.getAllPlayers().parallelStream().filter(p -> Objects.equals(p.getCurrentServer().orElse(null), server) && p.getUsername().startsWith(prefix)).map(Player::getUsername).toList());
        return this;
    }

    public TabBuilder players(Predicate<Player> filter) {
        if (this.server == null) {
            throw new NullPointerException("No proxy server instance provided");
        }
        this.list.addAll(this.server.getAllPlayers().stream().filter(filter).map(Player::getUsername).toList());
        return this;
    }

    public List<String> build() {
        return new ArrayList<String>(this.list);
    }
}

