/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.velocity.message;

import cn.afternode.commons.localizations.ILocalizations;
import com.velocitypowered.api.command.CommandSource;
import java.awt.Color;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class MessageBuilder {
    private ILocalizations localizations;
    private ComponentLike linePrefix = Component.text();
    private CommandSource target;
    private final TextComponent.Builder component = Component.text();

    public MessageBuilder(ILocalizations localizations, ComponentLike linePrefix, CommandSource target) {
        this.localizations = localizations;
        this.linePrefix = linePrefix;
        this.target = target;
        if (linePrefix != null) {
            this.component.append(linePrefix);
        }
    }

    public MessageBuilder() {
        this(null, null, null);
    }

    public MessageBuilder text(String text) {
        this.component.append((Component)Component.text((String)text));
        return this;
    }

    public MessageBuilder text(String text, Color color) {
        this.component.append(Component.text((String)text).color(TextColor.color((int)color.getRGB())));
        return this;
    }

    public MessageBuilder localize(String key, Map<String, Object> placeholders) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        return this.text(this.localizations.get(key, placeholders));
    }

    public MessageBuilder localize(String key) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        return this.text(this.localizations.get(key));
    }

    public MessageBuilder mini(String mini) {
        this.component.append(MiniMessage.miniMessage().deserialize((Object)mini));
        return this;
    }

    public MessageBuilder hover(HoverEventSource<?> source) {
        this.component.hoverEvent(source);
        return this;
    }

    public MessageBuilder click(ClickEvent event) {
        this.component.clickEvent(event);
        return this;
    }

    public MessageBuilder append(ComponentLike componentLike) {
        this.component.append(componentLike);
        return this;
    }

    public MessageBuilder line() {
        this.component.append((Component)Component.newline());
        this.component.append(this.linePrefix);
        return this;
    }

    public MessageBuilder emptyLine() {
        this.component.append((Component)Component.newline());
        return this;
    }

    public MessageBuilder gradient(String text, Color ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (Color color : colors) {
            mini.append(":").append("#%02x%02x%02x".formatted(color.getRed(), color.getGreen(), color.getBlue()));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public MessageBuilder gradient(String text, int ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (int color : colors) {
            mini.append(":").append("#%06x".formatted(color));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public MessageBuilder permission(String permission, ComponentLike componentLike) {
        if (this.target.hasPermission(permission)) {
            this.component.append(componentLike);
        }
        return this;
    }

    public ILocalizations localizations() {
        return this.localizations;
    }

    public MessageBuilder localizations(ILocalizations localizations) {
        this.localizations = localizations;
        return this;
    }

    public ComponentLike linePrefix() {
        return this.linePrefix;
    }

    public MessageBuilder linePrefix(ComponentLike linePrefix) {
        this.linePrefix = linePrefix;
        return this;
    }

    public CommandSource target() {
        return this.target;
    }

    public MessageBuilder target(CommandSource target) {
        this.target = target;
        return this;
    }

    public TextComponent build() {
        return (TextComponent)this.component.build();
    }

    public void send() {
        if (this.target == null) {
            throw new NullPointerException("No sender passed to this builder");
        }
        this.target.sendMessage((Component)this.build());
    }

    public void send(CommandSource target) {
        target.sendMessage((Component)this.build());
    }
}

