/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.mcnbt;

import cn.afternode.commons.mcnbt.SerializableNBT;
import cn.afternode.commons.serialization.DeserializeInstantiationException;
import cn.afternode.commons.serialization.FieldAccessException;
import de.tr7zw.changeme.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.changeme.nbtapi.iface.ReadableNBT;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class NBTSerializer {
    public static <T> void deserialize(ReadableNBT nbt, T object) {
        if (nbt == null || object == null) {
            throw new NullPointerException("nbt or object is null");
        }
        Class<?> type = object.getClass();
        if (!type.isAnnotationPresent(SerializableNBT.class)) {
            throw new IllegalArgumentException("%s has not SerializableNBT annotation".formatted(type.getName()));
        }
        SerializableNBT serializeNBT = type.getAnnotation(SerializableNBT.class);
        ReadableNBT comp = nbt.getCompound(serializeNBT.value());
        if (comp == null) {
            return;
        }
        for (Field f : type.getDeclaredFields()) {
            try {
                if (!f.isAnnotationPresent(SerializableNBT.class)) continue;
                SerializableNBT n = f.getAnnotation(SerializableNBT.class);
                Class<?> fType = f.getType();
                if (!comp.hasTag(n.value())) continue;
                if (List.class.isAssignableFrom(fType)) {
                    throw new IllegalArgumentException("Lists are not supported yet");
                }
                if (String.class.isAssignableFrom(fType)) {
                    f.set(object, comp.getString(n.value()));
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getByte(n.value()));
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getShort(n.value()));
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getInteger(n.value()));
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getLong(n.value()));
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getFloat(n.value()));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(fType)) {
                    f.set(object, comp.getFloat(n.value()));
                    continue;
                }
                if (byte[].class.isAssignableFrom(fType)) {
                    f.set(object, comp.getByteArray(n.value()));
                    continue;
                }
                if (int[].class.isAssignableFrom(fType)) {
                    f.set(object, comp.getIntArray(n.value()));
                    continue;
                }
                if (long[].class.isAssignableFrom(fType)) {
                    f.set(object, comp.getLongArray(n.value()));
                    continue;
                }
                Object obj = f.get(object);
                if (obj != null) {
                    NBTSerializer.deserialize(nbt, obj);
                    continue;
                }
                f.set(object, NBTSerializer.deserialize(nbt, fType));
            }
            catch (IllegalAccessException t) {
                throw new FieldAccessException(f, t);
            }
        }
    }

    public static <T> T deserialize(ReadableNBT nbt, Class<T> type) {
        try {
            Constructor<T> c = type.getDeclaredConstructor(new Class[0]);
            c.trySetAccessible();
            T obj = c.newInstance(new Object[0]);
            if (nbt != null) {
                NBTSerializer.deserialize(nbt, obj);
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new DeserializeInstantiationException("Type %s".formatted(type.getName()), (Throwable)ex);
        }
    }

    public static void serialize(ReadWriteNBT dest, Object obj) {
        if (dest == null || obj == null) {
            throw new NullPointerException("dest or obj is null");
        }
        Class<?> objType = obj.getClass();
        if (!objType.isAnnotationPresent(SerializableNBT.class)) {
            throw new IllegalArgumentException("%s was not a serializable object".formatted(objType.getName()));
        }
        SerializableNBT serializableNBT = objType.getAnnotation(SerializableNBT.class);
        ReadWriteNBT comp = dest.getOrCreateCompound(serializableNBT.value());
        for (Field f : objType.getDeclaredFields()) {
            try {
                if (!f.isAnnotationPresent(SerializableNBT.class)) continue;
                SerializableNBT anno = f.getAnnotation(SerializableNBT.class);
                f.trySetAccessible();
                Class<?> type = f.getType();
                String k = anno.value();
                Object o = f.get(anno);
                if (o == null) continue;
                if (List.class.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Lists are not supported yet");
                }
                if (String.class.isAssignableFrom(type)) {
                    comp.setString(k, (String)o);
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom(type)) {
                    comp.setByte(k, (Byte)o);
                    continue;
                }
                if (Short.TYPE.isAssignableFrom(type)) {
                    comp.setShort(k, (Short)o);
                    continue;
                }
                if (Long.TYPE.isAssignableFrom(type)) {
                    comp.setLong(k, (Long)o);
                    continue;
                }
                if (Float.TYPE.isAssignableFrom(type)) {
                    comp.setFloat(k, (Float)o);
                    continue;
                }
                if (Double.TYPE.isAssignableFrom(type)) {
                    comp.setDouble(k, (Double)o);
                    continue;
                }
                if (byte[].class.isAssignableFrom(type)) {
                    comp.setByteArray(k, (byte[])o);
                    continue;
                }
                if (int[].class.isAssignableFrom(type)) {
                    comp.setByte(k, (Byte)o);
                    continue;
                }
                if (long[].class.isAssignableFrom(type)) {
                    comp.setLongArray(k, (long[])o);
                    continue;
                }
                NBTSerializer.serialize(comp, o);
            }
            catch (IllegalAccessException t) {
                throw new FieldAccessException(f, t);
            }
        }
    }
}

