/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.database;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class ConnectionMonitor {
    private final long lifetime;
    private final HashMap<Connection, Long> stack = new HashMap();
    private final Thread thread;
    private boolean run;

    ConnectionMonitor(String name, long lifetime) {
        this.lifetime = lifetime;
        this.run = true;
        this.thread = new Thread(this::run);
        this.thread.setName("ConnectionMonitor-%s".formatted(name));
        this.thread.start();
    }

    public void add(Connection conn) {
        this.stack.put(conn, System.currentTimeMillis());
    }

    private void run() {
        while (this.run) {
            try {
                TimeUnit.SECONDS.sleep(5L);
                Iterator<Connection> it = this.stack.keySet().iterator();
                while (it.hasNext()) {
                    Connection conn = it.next();
                    if (System.currentTimeMillis() - this.stack.get(conn) < this.lifetime) continue;
                    conn.close();
                    it.remove();
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void close() {
        this.run = false;
        this.thread.interrupt();
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }
}

