/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.database;

import cn.afternode.commons.database.ConnectionMonitor;
import cn.afternode.commons.database.DatabaseUtils;
import cn.afternode.commons.database.IDatabaseManager;
import cn.afternode.commons.database.annotations.SQLSerialization;
import com.google.gson.Gson;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class HikariDatabaseManager
implements IDatabaseManager {
    private final HikariDataSource source;
    private final ConnectionMonitor monitor;
    private final Gson gson = new Gson();

    public static Builder builder() {
        return new Builder();
    }

    HikariDatabaseManager(HikariDataSource source, long connectionLifetime) {
        this.source = source;
        this.monitor = new ConnectionMonitor("Hikari", connectionLifetime);
    }

    @Override
    public void setup(String url, String username, String password) {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    public void close() {
        if (!this.source.isClosed()) {
            this.source.close();
        }
        if (this.monitor.isAlive()) {
            this.monitor.close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.source.getConnection();
    }

    @Override
    public void newTable(Class<?> table) throws SQLException {
        if (!table.isAnnotationPresent(SQLSerialization.Table.class)) {
            throw new IllegalArgumentException("%s has not SQLSerialization.Table annotation present".formatted(table.getName()));
        }
        SQLSerialization.Table anno = table.getAnnotation(SQLSerialization.Table.class);
        Object sql = "CREATE TABLE IF NOT EXISTS `%s` ".formatted(anno.name());
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Field f : table.getFields()) {
            if (!f.isAnnotationPresent(SQLSerialization.Column.class)) continue;
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(DatabaseUtils.toSQLCreateTable(f));
        }
        sb.append(")");
        sql = (String)sql + sb.toString();
        try (Statement stmt = this.getConnection().createStatement();){
            stmt.execute((String)sql);
        }
    }

    @Override
    public void insert(Object obj) throws SQLException {
        String sql = DatabaseUtils.toSQLInsert(obj);
        try (PreparedStatement stmt = this.getConnection().prepareStatement(sql);){
            try {
                DatabaseUtils.fillSQLInsert(obj, stmt);
            }
            catch (Throwable t) {
                throw new SQLException("Cannot fill SQL insert", t);
            }
            stmt.execute();
        }
    }

    public static class Builder {
        private long connectionLifetime = 10000L;
        private int maxSize = 50;
        private String name;
        private String url = null;
        private String username = null;
        private String password = null;
        private final Map<String, Object> prop = new HashMap<String, Object>();

        Builder() {
        }

        public Builder connectionLifetime(long value) {
            this.connectionLifetime = value;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder mysql(String host, int port, String name) {
            this.url = DatabaseUtils.getMySql(host, port, name);
            return this;
        }

        public Builder property(String key, Object value) {
            this.prop.put(key, value);
            return this;
        }

        public Builder maximumPoolSize(int size) {
            this.maxSize = size;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public HikariDatabaseManager build() {
            if (this.url == null) {
                throw new NullPointerException("JDBC url not present");
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.url);
            if (this.username != null) {
                config.setUsername(this.username);
            }
            if (this.password != null) {
                config.setPassword(this.password);
            }
            config.setMaximumPoolSize(this.maxSize);
            config.setMaxLifetime(this.connectionLifetime);
            config.setPoolName(this.name);
            for (String k : this.prop.keySet()) {
                config.addDataSourceProperty(k, this.prop.get(k));
            }
            HikariDataSource hds = new HikariDataSource(config);
            return new HikariDatabaseManager(hds, this.connectionLifetime);
        }
    }
}

