/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.database;

import cn.afternode.commons.database.SQLTypes;
import cn.afternode.commons.database.annotations.SQLSerialization;
import cn.afternode.commons.serialization.FieldAccessException;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DatabaseUtils {
    private static final Gson gson = new Gson();

    public static String getMySql(String host, int port, String database) {
        return "jdbc:mysql://%s:%s/%s".formatted(host, port, database);
    }

    public static String toSQLCreateTable(Field fd) {
        if (!fd.isAnnotationPresent(SQLSerialization.Column.class)) {
            throw new IllegalArgumentException("Column annotation not present");
        }
        SQLSerialization.Column col = fd.getAnnotation(SQLSerialization.Column.class);
        Object sql = "%s ".formatted(col.name());
        SQLTypes type = col.type();
        if (type == SQLTypes.TEXT && col.primaryKey()) {
            throw new IllegalArgumentException("TEXT type cannot be primary key");
        }
        if (type == SQLTypes.AUTO) {
            Class<?> ft = fd.getType();
            if (ft == String.class) {
                type = SQLTypes.VARCHAR;
            } else if (col.asJson()) {
                type = SQLTypes.TEXT;
            } else if (ft == Integer.TYPE || ft == Integer.class) {
                type = SQLTypes.INT;
            } else if (ft == Long.TYPE || ft == Long.class) {
                type = SQLTypes.BIGINT;
            } else if (ft == byte[].class) {
                type = SQLTypes.BLOB;
            } else {
                throw new RuntimeException("Type %s was not supported for AUTO type".formatted(ft.getName()));
            }
        }
        sql = (String)sql + type.getSql();
        if (col.notNull()) {
            sql = (String)sql + " NOT NULL";
        }
        if (col.primaryKey()) {
            sql = (String)sql + " PRIMARY KEY";
        }
        return sql;
    }

    public static String toSQLInsert(Object obj) {
        if (!obj.getClass().isAnnotationPresent(SQLSerialization.Table.class)) {
            throw new IllegalArgumentException("%s has not SQLSerialization.Table annotation present".formatted(obj.getClass().getName()));
        }
        SQLSerialization.Table anno = obj.getClass().getAnnotation(SQLSerialization.Table.class);
        Object sql = "INSERT INTO `%s` ".formatted(anno.name());
        StringBuilder names = new StringBuilder();
        StringBuilder values = new StringBuilder();
        names.append(" (");
        values.append("(");
        for (Field f : obj.getClass().getFields()) {
            if (!f.isAnnotationPresent(SQLSerialization.Column.class)) continue;
            SQLSerialization.Column col = f.getAnnotation(SQLSerialization.Column.class);
            if (!names.isEmpty()) {
                names.append(", ");
            }
            if (!values.isEmpty()) {
                values.append(", ");
            }
            names.append(col.name());
            values.append("?");
        }
        names.append(") VALUES");
        values.append(")");
        sql = (String)sql + names.toString() + values;
        return ((String)sql).toString();
    }

    public static void fillSQLInsert(Object obj, PreparedStatement stmt) throws SQLException {
        int index = 1;
        for (Field f : obj.getClass().getFields()) {
            if (!f.isAnnotationPresent(SQLSerialization.Column.class)) continue;
            try {
                SQLSerialization.Column col = f.getAnnotation(SQLSerialization.Column.class);
                f.setAccessible(true);
                Object fd = f.get(obj);
                switch (col.type()) {
                    case VARCHAR: 
                    case TEXT: {
                        stmt.setString(index, (String)fd);
                        break;
                    }
                    case INT: {
                        stmt.setInt(index, (Integer)fd);
                        break;
                    }
                    case BIGINT: {
                        stmt.setLong(index, (Long)fd);
                        break;
                    }
                    case BLOB: {
                        stmt.setBlob(index, new ByteArrayInputStream((byte[])fd));
                        break;
                    }
                    case AUTO: {
                        if (col.asJson()) {
                            stmt.setString(index, gson.toJson(fd));
                            break;
                        }
                        Class<?> ft = f.getType();
                        if (ft == String.class) {
                            stmt.setString(index, (String)fd);
                            break;
                        }
                        if (ft == Integer.TYPE || ft == Integer.class) {
                            stmt.setInt(index, (Integer)fd);
                            break;
                        }
                        if (ft == Long.TYPE || ft == Long.class) {
                            stmt.setLong(index, (Long)fd);
                            break;
                        }
                        if (ft == byte[].class) {
                            stmt.setBlob(index, new ByteArrayInputStream((byte[])fd));
                            break;
                        }
                        throw new RuntimeException("Type %s was not supported for AUTO type".formatted(ft.getName()));
                    }
                }
                ++index;
            }
            catch (IllegalAccessException ex) {
                throw new FieldAccessException(f, ex);
            }
        }
    }
}

