/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class NBungeeByteBuf {
    private final ByteBuf src;

    public NBungeeByteBuf(byte[] data) {
        this.src = Unpooled.copiedBuffer((byte[])data);
    }

    public NBungeeByteBuf() {
        this.src = Unpooled.buffer();
    }

    public void read(byte[] dest) {
        this.src.writeBytes(dest);
    }

    public void write(byte[] data) {
        this.src.writeBytes(data);
    }

    public byte[] read(int size) {
        byte[] data = new byte[size];
        this.src.readBytes(data);
        return data;
    }

    public byte[] readBlock() {
        return this.read(this.src.readShortLE());
    }

    public void writeBlock(byte[] data) {
        this.src.writeShortLE(data.length);
        this.src.writeBytes(data);
    }

    public byte[] readBlockL() {
        return this.read(this.src.readIntLE());
    }

    public void writeBlockL(byte[] data) {
        this.src.writeIntLE(data.length);
        this.src.writeBytes(data);
    }

    public short readShort() {
        return this.src.readShortLE();
    }

    public void writeShort(short data) {
        this.src.writeShortLE((int)data);
    }

    public int readInt() {
        return this.src.readIntLE();
    }

    public void writeInt(int data) {
        this.src.writeIntLE(data);
    }

    public long readLong() {
        return this.src.readLong();
    }

    public void writeLong(long data) {
        this.src.writeLong(data);
    }

    public String readString() {
        return new String(this.readBlock(), StandardCharsets.UTF_8);
    }

    public void writeString(String data) {
        this.writeBlock(data.getBytes(StandardCharsets.UTF_8));
    }

    public void writeEnum(Enum<?> e) {
        this.src.writeShortLE(e.ordinal());
    }

    public <T extends Enum<?>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.readShort()];
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public ProxiedPlayer readPlayer() {
        return ProxyServer.getInstance().getPlayer(this.readUUID());
    }

    public void writePlayer(ProxiedPlayer player) {
        this.writeUUID(player.getUniqueId());
    }

    public ByteBuf direct() {
        return this.src;
    }

    public byte[] toArray() {
        return this.src.array();
    }
}

