/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee.messaging;

import cn.afternode.commons.bungee.messaging.IMessageListener;
import cn.afternode.commons.bungee.messaging.MessageChannelContext;
import cn.afternode.commons.bungee.messaging.NBungeeByteBuf;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeMessagingHelper {
    private final Plugin plugin;
    private SecretKeySpec key;

    public BungeeMessagingHelper(Plugin plugin) {
        this.plugin = plugin;
    }

    public MessageChannelContext register(String channel, IMessageListener listener) {
        MessageChannelContext context = new MessageChannelContext(channel, this, listener);
        ProxyServer proxy = ProxyServer.getInstance();
        proxy.registerChannel(channel);
        proxy.getPluginManager().registerListener(this.plugin, (Listener)context);
        return context;
    }

    public boolean signingAvailable() {
        return this.key != null && !this.key.isDestroyed();
    }

    public void setKey(String key) {
        this.key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
    }

    public byte[] sign(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        if (!this.signingAvailable()) {
            throw new IllegalStateException("Signing not available");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.key);
        return mac.doFinal(data);
    }

    public byte[] combineSign(NBungeeByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException {
        NBungeeByteBuf nBuf = new NBungeeByteBuf();
        byte[] data = buf.toArray();
        nBuf.writeBlock(this.sign(data));
        nBuf.writeBlock(data);
        return nBuf.toArray();
    }

    public boolean validate(byte[] sign, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.signingAvailable()) {
            throw new IllegalStateException("Signing not available");
        }
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(this.key);
        return Arrays.equals(sign, mac.doFinal(data));
    }

    public NBungeeByteBuf validateCombined(NBungeeByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data;
        byte[] sign = buf.readBlock();
        if (!this.validate(sign, data = buf.readBlock())) {
            return null;
        }
        return new NBungeeByteBuf(data);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

