/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee.update;

public class SemVer {
    private final String src;
    private final int major;
    private final int minor;
    private final int patch;
    private final String extra;

    public SemVer(String version) {
        int numIndex = -1;
        char[] cs = version.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            try {
                Integer.parseInt(String.valueOf(cs[i]));
                numIndex = i;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
        }
        if (numIndex == -1) {
            throw new IllegalArgumentException("Cannot parse string %s as SemVer".formatted(version));
        }
        this.src = version.substring(numIndex);
        String[] parts = this.src.split("-");
        String[] vParts = parts[0].split("\\.");
        this.major = Integer.parseInt(vParts[0]);
        this.minor = Integer.parseInt(vParts[1]);
        this.patch = vParts.length >= 3 ? Integer.parseInt(vParts[2]) : 0;
        StringBuilder ex = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            if (!ex.isEmpty()) {
                ex.append("-");
            }
            ex.append(parts[i]);
        }
        this.extra = ex.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getExtra() {
        return this.extra;
    }

    public String toString() {
        return "SemVer{src='" + this.src + "', major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", extra='" + this.extra + "'}";
    }

    public static boolean isNewerThan(String fromStr, String targetStr) {
        SemVer target = new SemVer(targetStr);
        SemVer from = new SemVer(fromStr);
        if (target.major != from.major) {
            return target.major > from.major;
        }
        if (target.minor != from.minor) {
            return target.minor > from.minor;
        }
        return target.patch > from.patch;
    }
}

