/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee.messaging;

import cn.afternode.commons.bungee.messaging.BungeeMessagingHelper;
import cn.afternode.commons.bungee.messaging.IMessageListener;
import cn.afternode.commons.bungee.messaging.NBungeeByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class MessageChannelContext
implements Listener,
Closeable {
    private final String channel;
    private final BungeeMessagingHelper helper;
    private final IMessageListener listener;
    private boolean closed = false;

    MessageChannelContext(String channel, BungeeMessagingHelper helper, IMessageListener listener) {
        this.channel = channel;
        this.helper = helper;
        this.listener = listener;
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) {
        if (!this.channel.equals(event.getTag())) {
            return;
        }
        if (this.closed) {
            return;
        }
        Connection receiver = event.getReceiver();
        if (!(receiver instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)receiver;
        try {
            NBungeeByteBuf buf = new NBungeeByteBuf(event.getData());
            if (this.helper.signingAvailable()) {
                buf = this.helper.validateCombined(buf);
            }
            this.listener.onMessage(this.channel, player, buf);
        }
        catch (Throwable t) {
            throw new RuntimeException("(%s) Error handling plugin message from %s".formatted(this.channel, player.getName()));
        }
    }

    public void send(ProxiedPlayer player, NBungeeByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (this.closed) {
            throw new IOException("Using a closed channel");
        }
        byte[] data = this.helper.signingAvailable() ? this.helper.combineSign(buf) : buf.toArray();
        player.sendData(this.channel, data);
    }

    public void sendAll(NBungeeByteBuf buf) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.closed) {
            throw new IOException("Using a closed channel");
        }
        byte[] data = this.helper.signingAvailable() ? this.helper.combineSign(buf) : buf.toArray();
        for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
            if (server.getPlayers().isEmpty()) continue;
            server.sendData(this.channel, data);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        ProxyServer proxy = ProxyServer.getInstance();
        proxy.unregisterChannel(this.channel);
        proxy.getPluginManager().unregisterListener((Listener)this);
        this.closed = true;
    }
}

