/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee;

import cn.afternode.commons.bungee.BungeeTabBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePluginContext {
    private final Plugin plugin;

    public BungeePluginContext(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public BungeeTabBuilder tab() {
        return new BungeeTabBuilder();
    }

    public void saveResource(String path, Path out, boolean overwrite) throws IOException, NullPointerException {
        if (Files.exists(out, new LinkOption[0])) {
            return;
        }
        try (InputStream in = Objects.requireNonNull(this.plugin.getClass().getClassLoader().getResourceAsStream(path), () -> "%s @ resources".formatted(path));){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            Files.write(out, buffer.toByteArray(), new OpenOption[0]);
        }
    }
}

