/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bungee;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeeTabBuilder {
    private final List<String> comp = new ArrayList<String>();

    public BungeeTabBuilder append(String prefix, String ... append) {
        for (String a : append) {
            if (!a.startsWith(prefix)) continue;
            this.comp.add(a);
        }
        return this;
    }

    public BungeeTabBuilder append(String ... append) {
        this.comp.addAll(Arrays.asList(append));
        return this;
    }

    public BungeeTabBuilder players(String prefix, ServerInfo server) {
        for (ProxiedPlayer player : server.getPlayers()) {
            String name = player.getName();
            if (!name.startsWith(prefix)) continue;
            this.comp.add(name);
        }
        return this;
    }

    public BungeeTabBuilder players(Predicate<ProxiedPlayer> filter, ServerInfo server) {
        for (ProxiedPlayer player : server.getPlayers()) {
            if (!filter.test(player)) continue;
            this.comp.add(player.getName());
        }
        return this;
    }

    public BungeeTabBuilder players(ServerInfo server) {
        for (ProxiedPlayer player : server.getPlayers()) {
            this.comp.add(player.getName());
        }
        return this;
    }

    public BungeeTabBuilder players(Predicate<ProxiedPlayer> filter) {
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            if (!filter.test(player)) continue;
            this.comp.add(player.getName());
        }
        return this;
    }

    public BungeeTabBuilder players(String prefix) {
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            String name = player.getName();
            if (!name.startsWith(prefix)) continue;
            this.comp.add(name);
        }
        return this;
    }

    public BungeeTabBuilder players() {
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            this.comp.add(player.getName());
        }
        return this;
    }

    public BungeeTabBuilder servers() {
        for (ServerInfo si : ProxyServer.getInstance().getServers().values()) {
            this.comp.add(si.getName());
        }
        return this;
    }

    public BungeeTabBuilder servers(String prefix) {
        for (ServerInfo si : ProxyServer.getInstance().getServers().values()) {
            String name = si.getName();
            if (!name.startsWith(prefix)) continue;
            this.comp.add(name);
        }
        return this;
    }

    public BungeeTabBuilder servers(Predicate<ServerInfo> filter) {
        for (ServerInfo si : ProxyServer.getInstance().getServers().values()) {
            if (!filter.test(si)) continue;
            this.comp.add(si.getName());
        }
        return this;
    }

    public List<String> build() {
        return new ArrayList<String>(this.comp);
    }
}

