/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.report;

import cn.afternode.commons.bukkit.report.CustomElement;
import cn.afternode.commons.bukkit.report.ExceptionElement;
import cn.afternode.commons.bukkit.report.IPluginReportElement;
import cn.afternode.commons.bukkit.report.PluginInfoElement;
import cn.afternode.commons.bukkit.report.PluginListElement;
import cn.afternode.commons.bukkit.report.ServerInfoElement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class PluginReport {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private static final DateTimeFormatter FILENAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    private final Plugin plugin;
    private final List<IPluginReportElement> elements = new ArrayList<IPluginReportElement>();

    public PluginReport(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginReport appendElement(IPluginReportElement element) {
        this.elements.add(element);
        return this;
    }

    public PluginReport withServerInfo() {
        return this.appendElement(new ServerInfoElement(Bukkit.getServer()));
    }

    public PluginReport withPluginInfo() {
        return this.appendElement(new PluginInfoElement(this.plugin));
    }

    public PluginReport withPluginList() {
        return this.appendElement(new PluginListElement());
    }

    public PluginReport withException(String title, Throwable throwable) {
        return this.appendElement(new ExceptionElement(title, throwable));
    }

    public PluginReport withCustom(String title, String content) {
        return this.appendElement(new CustomElement(title, content));
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("=== Bukkit Plugin Report ===\n");
        builder.append("Generated at: ").append(DATE_TIME_FORMATTER.format(ZonedDateTime.now())).append("\n");
        builder.append("By: ").append(this.plugin.getName()).append("\n");
        for (IPluginReportElement element : this.elements) {
            builder.append("===").append(element.title()).append("===\n");
            builder.append(element.build()).append("\n");
        }
        return builder.toString();
    }

    public void save(Path target) throws IOException {
        if (Files.notExists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        Files.writeString(target, (CharSequence)this.build(), new OpenOption[0]);
    }

    public Path save() throws IOException {
        Path result = Path.of("reports", new String[0]).resolve("report-%s-%s.txt".formatted(FILENAME_DATE_TIME_FORMATTER.format(ZonedDateTime.now()), this.plugin.getName()));
        this.save(result);
        return result;
    }

    public Path saveToDataFolder() throws IOException {
        Path result = this.plugin.getDataFolder().toPath().resolve("report-%s-%s.txt");
        this.save(result);
        return result;
    }

    public Path saveAndLog() throws IOException {
        Path result = this.save();
        this.plugin.getLogger().info("Report saved to " + result);
        return result;
    }
}

