/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.gui;

import cn.afternode.commons.bukkit.message.MessageBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private Material material;
    private Component name = null;
    private final List<Component> lore = new ArrayList<Component>();
    private Integer model = -1;
    private final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private final Set<ItemFlag> flags = new HashSet<ItemFlag>();
    private boolean unbreakable = false;
    private final Multimap<Attribute, AttributeModifier> attributes = HashMultimap.create();

    public ItemBuilder(Material material) {
        this.material(material);
    }

    public ItemBuilder material(Material material) {
        if (material.isAir()) {
            throw new IllegalArgumentException("Cannot create air item");
        }
        this.material = material;
        return this;
    }

    public Material material() {
        return this.material;
    }

    public ItemBuilder name(ComponentLike name) {
        this.name = name.asComponent();
        return this;
    }

    public ItemBuilder name(Component name) {
        this.name = name;
        return this;
    }

    public ItemBuilder name(MessageBuilder builder) {
        return this.name((Component)builder.build());
    }

    public Component name() {
        return this.name;
    }

    public ItemBuilder lore(ComponentLike ... lore) {
        for (ComponentLike c : lore) {
            this.lore.add(c.asComponent());
        }
        return this;
    }

    public ItemBuilder lore(MessageBuilder ... lore) {
        for (MessageBuilder c : lore) {
            this.lore.add((Component)c.build());
        }
        return this;
    }

    public ItemBuilder lore(Component ... lore) {
        Collections.addAll(this.lore, lore);
        return this;
    }

    public ItemBuilder newLore() {
        this.lore.clear();
        return this;
    }

    public ItemBuilder model(Integer model) {
        this.model = model;
        return this;
    }

    public Integer model() {
        return this.model;
    }

    public ItemBuilder enchant(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ItemBuilder removeEnchant(Enchantment enchantment) {
        this.enchantments.remove(enchantment);
        return this;
    }

    public Integer enchant(Enchantment enchantment) {
        return this.enchantments.getOrDefault(enchantment, null);
    }

    public ItemBuilder clearEnchantments() {
        this.enchantments.clear();
        return this;
    }

    public ItemBuilder flag(ItemFlag ... flags) {
        Collections.addAll(this.flags, flags);
        return this;
    }

    public ItemBuilder removeFlags(ItemFlag ... flags) {
        for (ItemFlag flag : flags) {
            this.flags.remove(flag);
        }
        return this;
    }

    public Set<ItemFlag> flags() {
        return new HashSet<ItemFlag>(this.flags);
    }

    public ItemBuilder clearFlags() {
        this.flags.clear();
        return this;
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public boolean unbreakable() {
        return this.unbreakable;
    }

    public ItemBuilder attribute(Attribute attribute, AttributeModifier ... modifiers) {
        for (AttributeModifier modifier : modifiers) {
            this.attributes.put((Object)attribute, (Object)modifier);
        }
        return this;
    }

    public Collection<AttributeModifier> attribute(Attribute attribute) {
        return this.attributes.get((Object)attribute);
    }

    public Multimap<Attribute, AttributeModifier> attributes() {
        return HashMultimap.create(this.attributes);
    }

    public ItemBuilder clearAttributes() {
        this.attributes.clear();
        return this;
    }

    public ItemStack build() {
        ItemStack stack = new ItemStack(this.material);
        ItemMeta meta = Bukkit.getItemFactory().getItemMeta(this.material);
        if (this.name != null) {
            meta.displayName(this.name);
        }
        if (!this.lore.isEmpty()) {
            meta.lore(this.lore);
        }
        meta.setCustomModelData(this.model);
        this.enchantments.forEach((e, l) -> meta.addEnchant(e, l.intValue(), true));
        meta.addItemFlags(this.flags.toArray(new ItemFlag[0]));
        meta.setUnbreakable(this.unbreakable);
        this.attributes.forEach((arg_0, arg_1) -> ((ItemMeta)meta).addAttributeModifier(arg_0, arg_1));
        stack.setItemMeta(meta);
        return stack;
    }
}

