/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.messaging;

import cn.afternode.commons.bukkit.messaging.BukkitMessagingHelper;
import cn.afternode.commons.bukkit.messaging.IMessageListener;
import cn.afternode.commons.bukkit.messaging.NBukkitByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class MessageChannelContext
implements PluginMessageListener,
Closeable {
    private final String channel;
    private final BukkitMessagingHelper helper;
    private final IMessageListener listener;
    private boolean closed = false;

    MessageChannelContext(String channel, BukkitMessagingHelper helper, IMessageListener listener) {
        this.channel = channel;
        this.helper = helper;
        this.listener = listener;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        if (!this.channel.equals(channel)) {
            return;
        }
        if (this.closed) {
            return;
        }
        try {
            NBukkitByteBuf buf = new NBukkitByteBuf(message);
            if (this.helper.signingAvailable()) {
                buf = this.helper.validateCombined(buf);
            }
            this.listener.onMessage(channel, player, buf);
        }
        catch (Throwable t) {
            throw new RuntimeException("(%s) Error handling plugin message from %s".formatted(channel, player.getName()));
        }
    }

    public void send(Player player, NBukkitByteBuf buf) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (this.closed) {
            throw new IOException("Using a closed channel");
        }
        byte[] data = this.helper.signingAvailable() ? this.helper.combineSign(buf) : buf.toArray();
        player.sendPluginMessage(this.helper.getPlugin(), this.channel, data);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        Messenger m = Bukkit.getMessenger();
        m.unregisterIncomingPluginChannel(this.helper.getPlugin(), this.channel);
        m.unregisterOutgoingPluginChannel(this.helper.getPlugin());
        this.closed = true;
    }
}

