/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.message;

import cn.afternode.commons.bukkit.BukkitPluginContext;
import cn.afternode.commons.bukkit.IAdventureLocalizations;
import cn.afternode.commons.bukkit.message.ComponentStyle;
import cn.afternode.commons.bukkit.message.RegisteredClickCallback;
import cn.afternode.commons.localizations.ILocalizations;
import java.awt.Color;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.Nullable;

public class MessageBuilder {
    private ILocalizations localizations;
    private ComponentLike linePrefix = Component.text();
    private CommandSender sender;
    private IAdventureLocalizations.LocalizeMode localizeMode = IAdventureLocalizations.LocalizeMode.RAW;
    private Stack<ComponentStyle> styleStack = null;
    private final TextComponent.Builder component = Component.text();

    public MessageBuilder(@Nullable ILocalizations locale, @Nullable ComponentLike linePrefix, @Nullable CommandSender sender, boolean styleStack) {
        this.localizations = locale;
        if (linePrefix != null) {
            this.linePrefix = linePrefix;
        }
        this.sender = sender;
        if (styleStack) {
            this.useStyleStack();
        }
        this.component.append(this.linePrefix);
    }

    public MessageBuilder(@Nullable ILocalizations locale) {
        this(locale, null, null, false);
    }

    public MessageBuilder() {
        this(null, null, null, false);
    }

    public MessageBuilder(boolean styleStack) {
        this(null, null, null, styleStack);
    }

    public void pushStyle() {
        this.styleStack.push(new ComponentStyle());
    }

    public ComponentStyle style() {
        if (this.styleStack != null) {
            return this.styleStack.peek();
        }
        return null;
    }

    public void popStyle() {
        this.styleStack.pop();
    }

    public void clearStyle() {
        this.styleStack.clear();
        this.styleStack.push(new ComponentStyle());
    }

    public void useStyleStack() {
        this.styleStack = new Stack();
        this.styleStack.push(new ComponentStyle());
    }

    public MessageBuilder localize(String key, Map<String, Object> placeholders) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        if (this.localizeMode == IAdventureLocalizations.LocalizeMode.RAW) {
            ComponentStyle style = this.style();
            this.component.append((Component)(style == null ? Component.text((String)this.localizations.get(key, placeholders)) : Component.text((String)this.localizations.get(key, placeholders), (Style)style.build())));
        } else {
            ILocalizations iLocalizations = this.localizations;
            if (iLocalizations instanceof IAdventureLocalizations) {
                IAdventureLocalizations advntr = (IAdventureLocalizations)iLocalizations;
                this.component.append((Component)(this.localizeMode == IAdventureLocalizations.LocalizeMode.LEGACY ? advntr.legacy(key, placeholders) : advntr.mini(key, placeholders)));
            } else {
                throw new UnsupportedOperationException(this.localizations.getClass().getName() + " does not supports " + this.localizeMode.name() + " mode");
            }
        }
        return this;
    }

    public MessageBuilder localize(String key) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        if (this.localizeMode == IAdventureLocalizations.LocalizeMode.RAW) {
            ComponentStyle style = this.style();
            this.component.append((Component)(style == null ? Component.text((String)this.localizations.get(key)) : Component.text((String)this.localizations.get(key), (Style)style.build())));
        } else {
            ILocalizations iLocalizations = this.localizations;
            if (iLocalizations instanceof IAdventureLocalizations) {
                IAdventureLocalizations advntr = (IAdventureLocalizations)iLocalizations;
                this.component.append((Component)(this.localizeMode == IAdventureLocalizations.LocalizeMode.LEGACY ? advntr.legacy(key) : advntr.mini(key)));
            } else {
                throw new UnsupportedOperationException(this.localizations.getClass().getName() + " does not supports " + this.localizeMode.name() + " mode");
            }
        }
        return this;
    }

    public MessageBuilder localize(String key, String ... args) {
        if (this.localizations == null) {
            throw new NullPointerException("No localizations passed to this builder");
        }
        if (this.localizeMode == IAdventureLocalizations.LocalizeMode.RAW) {
            ComponentStyle style = this.style();
            this.component.append((Component)(style == null ? Component.text((String)this.localizations.get(key, args)) : Component.text((String)this.localizations.get(key, args), (Style)style.build())));
        } else {
            ILocalizations iLocalizations = this.localizations;
            if (iLocalizations instanceof IAdventureLocalizations) {
                IAdventureLocalizations advntr = (IAdventureLocalizations)iLocalizations;
                this.component.append((Component)(this.localizeMode == IAdventureLocalizations.LocalizeMode.LEGACY ? advntr.legacy(key, args) : advntr.mini(key, args)));
            } else {
                throw new UnsupportedOperationException(this.localizations.getClass().getName() + " does not supports " + this.localizeMode.name() + " mode");
            }
        }
        return this;
    }

    public MessageBuilder text(String text) {
        ComponentStyle style = this.style();
        this.component.append((Component)(style == null ? Component.text((String)text) : Component.text((String)text, (Style)style.build())));
        return this;
    }

    public MessageBuilder text(String text, Color color) {
        this.component.append(Component.text((String)text).color(TextColor.color((int)color.getRGB())));
        return this;
    }

    public MessageBuilder mini(String mini) {
        this.component.append(MiniMessage.miniMessage().deserialize((Object)mini));
        return this;
    }

    public MessageBuilder hover(HoverEventSource<?> source) {
        this.component.hoverEvent(source);
        return this;
    }

    public MessageBuilder click(ClickEvent event) {
        this.component.clickEvent(event);
        return this;
    }

    public MessageBuilder click(BukkitPluginContext context, boolean once, Consumer<Player> callback) {
        RegisteredClickCallback reg = context.getCallbackCommand().register(once, callback);
        return this.click(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/%s:%s %s".formatted(context.getPlugin().getName(), context.getCallbackCommand().getName(), reg.id())));
    }

    public MessageBuilder click(BukkitPluginContext context, Consumer<Player> callback) {
        RegisteredClickCallback reg = context.getCallbackCommand().register(callback);
        return this.click(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)"/%s:%s %s".formatted(context.getPlugin().getName(), context.getCallbackCommand().getName(), reg.id())));
    }

    public MessageBuilder append(ComponentLike componentLike) {
        this.component.append(componentLike);
        return this;
    }

    public MessageBuilder line() {
        this.component.append((Component)Component.newline());
        this.component.append(this.linePrefix);
        return this;
    }

    public MessageBuilder emptyLine() {
        this.component.append((Component)Component.newline());
        return this;
    }

    public MessageBuilder permission(String permission, ComponentLike componentLike) {
        if (this.sender.hasPermission(permission)) {
            this.component.append(componentLike);
        }
        return this;
    }

    public MessageBuilder permission(Permission permission, ComponentLike component) {
        if (this.sender.hasPermission(permission)) {
            this.component.append(component);
        }
        return this;
    }

    public MessageBuilder gradient(String text, Color ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (Color color : colors) {
            mini.append(":").append("#%02x%02x%02x".formatted(color.getRed(), color.getGreen(), color.getBlue()));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public MessageBuilder gradient(String text, int ... colors) {
        StringBuilder mini = new StringBuilder();
        mini.append("<gradient");
        for (int color : colors) {
            mini.append(":").append("#%06x".formatted(color));
        }
        mini.append(">").append(text).append("</gradient>");
        return this.mini(mini.toString());
    }

    public TextComponent build() {
        return (TextComponent)this.component.build();
    }

    public void send() {
        if (this.sender == null) {
            throw new NullPointerException("No sender passed to this builder");
        }
        this.sender.sendMessage((Component)this.build());
    }

    public void send(CommandSender sender) {
        sender.sendMessage((Component)this.build());
    }

    public ILocalizations getLocalizations() {
        return this.localizations;
    }

    public MessageBuilder localizations(ILocalizations localizations) {
        this.localizations = localizations;
        return this;
    }

    public ComponentLike getLinePrefix() {
        return this.linePrefix;
    }

    public MessageBuilder linePrefix(ComponentLike prefix) {
        this.linePrefix = prefix;
        return this;
    }

    public IAdventureLocalizations.LocalizeMode getLocalizeMode() {
        return this.localizeMode;
    }

    public MessageBuilder localizeMode(IAdventureLocalizations.LocalizeMode mode) {
        this.localizeMode = mode;
        return this;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public MessageBuilder sender(CommandSender sender) {
        this.sender = sender;
        return this;
    }
}

