/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.message;

import java.awt.Color;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class ComponentStyle {
    private TextColor color = TextColor.color((int)0xFFFFFF);
    private boolean italic = false;
    private boolean bold = false;
    private boolean underline = false;
    private boolean strike = false;
    private boolean obfuscated = false;

    public TextColor color() {
        return this.color;
    }

    public ComponentStyle color(TextColor color) {
        this.color = color;
        return this;
    }

    public ComponentStyle color(Color color) {
        this.color = TextColor.color((int)color.getRGB());
        return this;
    }

    public boolean italic() {
        return this.italic;
    }

    public ComponentStyle italic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public boolean bold() {
        return this.bold;
    }

    public ComponentStyle bold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public boolean underline() {
        return this.underline;
    }

    public ComponentStyle underline(boolean underline) {
        this.underline = underline;
        return this;
    }

    public boolean strike() {
        return this.strike;
    }

    public ComponentStyle strike(boolean strike) {
        this.strike = strike;
        return this;
    }

    public boolean obfuscated() {
        return this.obfuscated;
    }

    public ComponentStyle obfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
        return this;
    }

    public Style build() {
        Style.Builder builder = Style.style();
        builder.color(this.color);
        if (this.italic) {
            builder.decoration(TextDecoration.ITALIC, true);
        }
        if (this.bold) {
            builder.decoration(TextDecoration.BOLD, true);
        }
        if (this.underline) {
            builder.decoration(TextDecoration.UNDERLINED, true);
        }
        if (this.strike) {
            builder.decoration(TextDecoration.STRIKETHROUGH, true);
        }
        if (this.obfuscated) {
            builder.decoration(TextDecoration.OBFUSCATED, true);
        }
        return builder.build();
    }
}

