/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.message;

import cn.afternode.commons.bukkit.message.RegisteredClickCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CallbackCommand
extends Command {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final Map<UUID, RegisteredClickCallback> registry = new HashMap<UUID, RegisteredClickCallback>();

    public CallbackCommand() {
        super("callback-" + counter.incrementAndGet());
    }

    public boolean execute(@NotNull CommandSender commandSender, @NotNull String s, @NotNull String[] args) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            try {
                UUID id = UUID.fromString(args[0]);
                if (this.registry.containsKey(id)) {
                    RegisteredClickCallback reg = this.registry.get(id);
                    reg.callback().accept(player);
                    if (reg.once()) {
                        this.registry.remove(id);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }

    public RegisteredClickCallback register(boolean once, Consumer<Player> callback) {
        UUID id = UUID.randomUUID();
        RegisteredClickCallback reg = new RegisteredClickCallback(id, once, callback);
        this.registry.put(id, reg);
        return reg;
    }

    public RegisteredClickCallback register(Consumer<Player> callback) {
        return this.register(true, callback);
    }

    public void unregister(@NotNull UUID id) {
        this.registry.remove(id);
    }
}

