/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.gui;

import cn.afternode.commons.bukkit.gui.IGui;
import cn.afternode.commons.bukkit.gui.OpenedGui;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;

public class GuiManager
implements Listener {
    private final Map<UUID, OpenedGui> opened = new HashMap<UUID, OpenedGui>();

    public GuiManager(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public OpenedGui open(Player target, IGui gui) {
        Inventory inv = gui.createInventory(target);
        InventoryView view = target.openInventory(inv);
        OpenedGui open = new OpenedGui(target, view, gui);
        this.opened.put(target.getUniqueId(), open);
        return open;
    }

    public OpenedGui getOpened(InventoryHolder holder) {
        if (holder instanceof Player) {
            Player player = (Player)holder;
            return this.opened.get(player.getUniqueId());
        }
        return null;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        this.opened.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity who = event.getWhoClicked();
        if (who instanceof Player && this.opened.containsKey((player = (Player)who).getUniqueId())) {
            OpenedGui gui = this.opened.get(player.getUniqueId());
            if (event.getSlot() == event.getRawSlot()) {
                try {
                    event.setCancelled(gui.gui().onSlotClick(player, event, gui));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error handling click on player %s, slot %s".formatted(player.getName(), event.getSlot()), t);
                }
            } else if (event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                event.setCancelled(true);
            }
        }
    }
}

