/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit;

import cn.afternode.commons.bukkit.IAdventureLocalizations;
import cn.afternode.commons.localizations.ILocalizations;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class JsonLocalizations
implements IAdventureLocalizations {
    private final JsonObject lang;
    private LegacyComponentSerializer legacy = LegacyComponentSerializer.legacySection();
    private MiniMessage mini = MiniMessage.miniMessage();

    public JsonLocalizations(JsonObject obj) {
        this.lang = obj;
    }

    public JsonLocalizations(ClassLoader loader, String path) {
        this((JsonObject)new Gson().fromJson((Reader)new InputStreamReader(Objects.requireNonNull(loader.getResourceAsStream(path))), JsonObject.class));
    }

    public JsonLocalizations(String path) {
        this(JsonLocalizations.class.getClassLoader(), path);
    }

    public JsonLocalizations(ClassLoader loader, String namespace, String langCode) {
        this(loader, JsonLocalizations.getResourcePath(namespace, langCode));
    }

    public JsonLocalizations(String namespace, String langCode) {
        this(JsonLocalizations.class.getClassLoader(), namespace, langCode);
    }

    public String get(String key) {
        JsonElement el = this.lang.get(key);
        return el.isJsonPrimitive() ? el.getAsString() : key;
    }

    public String get(String key, Map<String, Object> placeholders) {
        String get = this.get(key);
        for (String k : placeholders.keySet()) {
            get = get.replace("%" + k + "%", String.valueOf(placeholders.get(k)));
        }
        return get;
    }

    public String get(String key, String ... args) {
        return this.get(key).formatted(args);
    }

    public Set<String> keys() {
        return this.lang.keySet();
    }

    public static String getResourcePath(String namespace, String langCode) {
        return "assets/%s/lang/%s.json".formatted(namespace, langCode);
    }

    @Override
    public TextComponent legacy(String key) {
        return this.legacy.deserialize(this.get(key));
    }

    @Override
    public TextComponent legacy(String key, Map<String, Object> placeholders) {
        return this.legacy.deserialize(this.get(key, placeholders));
    }

    @Override
    public TextComponent legacy(String key, String ... args) {
        return this.legacy.deserialize(this.get(key, args));
    }

    @Override
    public Component mini(String key) {
        return this.mini.deserialize((Object)this.get(key));
    }

    @Override
    public Component mini(String key, Map<String, Object> placeholders) {
        return this.mini.deserialize((Object)this.get(key, placeholders));
    }

    @Override
    public Component mini(String key, String ... args) {
        return this.mini.deserialize((Object)this.get(key, args));
    }

    @Override
    public void withLegacySerializer(LegacyComponentSerializer serializer) {
        this.legacy = serializer;
    }

    @Override
    public void withMiniMessage(MiniMessage mm) {
        this.mini = mm;
    }

    public JsonLocalizations withFallback(ILocalizations fallback) {
        JsonObject n = new JsonObject();
        for (String key : fallback.keys()) {
            n.addProperty(key, fallback.get(key));
        }
        for (String key : this.lang.keySet()) {
            n.add(key, this.lang.get(key));
        }
        return new JsonLocalizations(n);
    }
}

