/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.report;

import cn.afternode.commons.bukkit.report.IPluginReportElement;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;

public class PluginInfoElement
implements IPluginReportElement {
    private final Plugin plugin;
    private boolean withWebsite = true;
    private boolean withLibraries = false;
    private boolean withDepends = true;
    private boolean withSoftDepends = true;
    private boolean withLoadBefore = false;
    private boolean withPluginNotFound = false;

    public PluginInfoElement(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String title() {
        return "Plugin Info of " + this.plugin.getName();
    }

    public PluginInfoElement withWebsite(boolean state) {
        this.withWebsite = state;
        return this;
    }

    public PluginInfoElement withLibraries(boolean state) {
        this.withLibraries = state;
        return this;
    }

    public PluginInfoElement withDepends(boolean state) {
        this.withDepends = state;
        return this;
    }

    public PluginInfoElement withSoftDepends(boolean state) {
        this.withSoftDepends = state;
        return this;
    }

    public PluginInfoElement withLoadBefore(boolean state) {
        this.withLoadBefore = state;
        return this;
    }

    public PluginInfoElement withPluginNotFound(boolean state) {
        this.withPluginNotFound = state;
        return this;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        PluginDescriptionFile desc = this.plugin.getDescription();
        sb.append("Version: ").append(desc.getVersion()).append("\n");
        sb.append("API-Version: ").append(desc.getAPIVersion()).append("\n");
        if (this.withWebsite) {
            sb.append("Website: ").append(desc.getWebsite()).append("\n");
        }
        PluginManager mgr = Bukkit.getPluginManager();
        if (this.withDepends) {
            sb.append("Depends: \n");
            for (String depend : desc.getDepend()) {
                sb.append("    ").append(depend);
                if (this.withPluginNotFound && mgr.getPlugin(depend) == null) {
                    sb.append(" [NOT FOUND]");
                }
                sb.append("\n");
            }
        }
        if (this.withSoftDepends) {
            sb.append("Soft Depends: \n");
            for (String depend : desc.getSoftDepend()) {
                sb.append("    ").append(depend);
                if (this.withPluginNotFound && mgr.getPlugin(depend) == null) {
                    sb.append(" [NOT FOUND]");
                }
                sb.append("\n");
            }
        }
        if (this.withLoadBefore) {
            sb.append("Load Before: \n");
            for (String depend : desc.getLoadBefore()) {
                sb.append("    ").append(depend);
                if (this.withPluginNotFound && mgr.getPlugin(depend) == null) {
                    sb.append(" [NOT FOUND]");
                }
                sb.append("\n");
            }
        }
        if (this.withLibraries) {
            sb.append("Libraries: \n");
            for (String library : desc.getLibraries()) {
                sb.append("    ").append(library);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

