/*
 * Decompiled with CFR 0.152.
 */
package cn.afternode.commons.bukkit.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class NBukkitByteBuf {
    private final ByteBuf src;

    public NBukkitByteBuf(byte[] data) {
        this.src = Unpooled.copiedBuffer((byte[])data);
    }

    public NBukkitByteBuf() {
        this.src = Unpooled.buffer();
    }

    public void read(byte[] dest) {
        this.src.writeBytes(dest);
    }

    public void write(byte[] data) {
        this.src.writeBytes(data);
    }

    public byte[] read(int size) {
        byte[] data = new byte[size];
        this.src.readBytes(data);
        return data;
    }

    public byte[] readBlock() {
        return this.read(this.src.readShortLE());
    }

    public void writeBlock(byte[] data) {
        this.src.writeShortLE(data.length);
        this.src.writeBytes(data);
    }

    public byte[] readBlockL() {
        return this.read(this.src.readIntLE());
    }

    public void writeBlockL(byte[] data) {
        this.src.writeIntLE(data.length);
        this.src.writeBytes(data);
    }

    public short readShort() {
        return this.src.readShortLE();
    }

    public void writeShort(short data) {
        this.src.writeShortLE((int)data);
    }

    public int readInt() {
        return this.src.readIntLE();
    }

    public void writeInt(int data) {
        this.src.writeIntLE(data);
    }

    public long readLong() {
        return this.src.readLong();
    }

    public void writeLong(long data) {
        this.src.writeLong(data);
    }

    public String readString() {
        return new String(this.readBlock(), StandardCharsets.UTF_8);
    }

    public void writeString(String data) {
        this.writeBlock(data.getBytes(StandardCharsets.UTF_8));
    }

    public void writeEnum(Enum<?> e) {
        this.src.writeShortLE(e.ordinal());
    }

    public <T extends Enum<?>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.readShort()];
    }

    public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    public void writeUUID(UUID uuid) {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public Player readPlayer() {
        return Bukkit.getPlayer((UUID)this.readUUID());
    }

    public OfflinePlayer readPlayerOffline() {
        return Bukkit.getOfflinePlayer((UUID)this.readUUID());
    }

    public void writePlayer(OfflinePlayer player) {
        this.writeUUID(player.getUniqueId());
    }

    public ItemStack readItemStack() throws IOException, ClassNotFoundException {
        byte[] data = this.readBlock();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BukkitObjectInputStream in = new BukkitObjectInputStream((InputStream)bais);
        return (ItemStack)in.readObject();
    }

    public void writeItemStack(ItemStack item) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BukkitObjectOutputStream boos = new BukkitObjectOutputStream((OutputStream)baos);
        boos.writeObject((Object)item);
        this.writeBlock(baos.toByteArray());
    }

    public ByteBuf direct() {
        return this.src;
    }

    public byte[] toArray() {
        return this.src.array();
    }
}

